/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.label;

import gov.nasa.giss.gui.plaf.MultiLineLabelUI;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class MultiLineLabel
extends JComponent
implements PropertyChangeListener,
SwingConstants {
    private String text_;
    private int hAlignment_ = 2;
    private int vAlignment_ = 1;

    public MultiLineLabel() {
        this("");
    }

    public MultiLineLabel(String text) {
        this(text, 2);
    }

    public MultiLineLabel(String text, int halign) {
        this.setText(text);
        this.setHorizontalAlignment(halign);
        Font f = UIManager.getDefaults().getFont("Label.font");
        if (f != null) {
            this.setFont(f);
        }
        this.setUI(new MultiLineLabelUI());
        this.addPropertyChangeListener(this);
    }

    public void setUI(MultiLineLabelUI ui) {
        super.setUI(ui);
    }

    public String getText() {
        return this.text_;
    }

    public void setText(String s) {
        this.text_ = s;
        this.repaint();
    }

    public void setBorder(Border b) {
        super.setBorder(b);
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.repaint();
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.hAlignment_;
    }

    public void setHorizontalAlignment(int i) {
        this.hAlignment_ = i;
        this.repaint();
    }

    public int getVerticalAlignment() {
        return this.vAlignment_;
    }

    public void setVerticalAlignment(int i) {
        this.vAlignment_ = i;
        this.repaint();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equalsIgnoreCase("JComponent.sizeVariant")) {
            String value = e.getNewValue().toString();
            double multiple = 1.0;
            if (value.toString().equalsIgnoreCase("small")) {
                multiple = 0.8;
            } else if (value.toString().equalsIgnoreCase("mini")) {
                multiple = 0.6;
            }
            Font f = UIManager.getDefaults().getFont("Label.font");
            if (multiple < 1.0) {
                f = f.deriveFont((float)Math.floor((double)f.getSize() * multiple));
            }
            this.setFont(f);
        }
    }
}

