/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.filechooser;

import gov.nasa.giss.gui.filechooser.ExtFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class SaveFileChooser
extends JFileChooser
implements ActionListener,
PropertyChangeListener {
    private static File recentPath_;

    public SaveFileChooser(File f) {
        this();
        this.setCurrentDirectory(f);
        this.setSelectedFile(f);
    }

    public SaveFileChooser(String name) {
        this();
        this.setFileName(name);
    }

    public SaveFileChooser(File folder, String name) {
        this();
        try {
            File f = new File(folder, name);
            this.setSelectedFile(f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SaveFileChooser() {
        this.setDialogType(1);
        this.setDialogTitle("Save as\u2026");
        this.setFileName("Unnamed image");
        this.setMultiSelectionEnabled(false);
        if (recentPath_ != null) {
            this.setCurrentDirectory(recentPath_);
        }
        this.setAcceptAllFileFilterUsed(false);
        this.addActionListener(this);
        this.addPropertyChangeListener(this);
    }

    public void setFileName(String fname) {
        if (fname == null) {
            throw new IllegalArgumentException("Filename is null");
        }
        try {
            File f = new File(this.getCurrentDirectory(), fname);
            this.setSelectedFile(f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JTextField findTextField(Component c) {
        if (c.getClass() == JTextField.class) {
            return (JTextField)c;
        }
        if (c instanceof Container) {
            for (Component child : ((Container)c).getComponents()) {
                JTextField found = this.findTextField(child);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public void approveSelection() {
        ExtFileFilter eff;
        File file = this.getSelectedFile();
        if (file == null) {
            this.cancelSelection();
            return;
        }
        FileFilter ff = this.getFileFilter();
        if (ff instanceof ExtFileFilter && !(eff = (ExtFileFilter)ff).accept(file)) {
            file = new File(file.getParentFile(), file.getName() + "." + eff.getExtensions()[0]);
            this.setSelectedFile(file);
        }
        if (file.exists()) {
            int choice = JOptionPane.showOptionDialog(this, "A file by that name already exists.\nDo you want to replace it?", null, 0, 3, null, new String[]{"Replace", "Cancel"}, null);
            if (choice == 0) {
                super.approveSelection();
            } else if (choice == 1) {
                return;
            }
        } else {
            super.approveSelection();
        }
    }

    public void setExtension(String ext) {
        FileFilter[] filters = this.getChoosableFileFilters();
        String fauxname = "foo." + ext;
        for (int i = 0; i < filters.length; ++i) {
            ExtFileFilter f = (ExtFileFilter)filters[i];
            if (!f.accept(fauxname)) continue;
            this.setFileFilter(f);
            return;
        }
    }

    private void validateExtension() {
        JTextField nameTF = this.findTextField(this);
        if (nameTF == null) {
            return;
        }
        String fname = nameTF.getText();
        if (fname.lastIndexOf(".") < 1) {
            return;
        }
        FileFilter currentFilter = this.getFileFilter();
        if (!(currentFilter instanceof ExtFileFilter)) {
            return;
        }
        ExtFileFilter ceff = (ExtFileFilter)currentFilter;
        if (ceff.accept(fname)) {
            return;
        }
        for (FileFilter filter : this.getChoosableFileFilters()) {
            ExtFileFilter eff;
            if (!(filter instanceof ExtFileFilter) || !(eff = (ExtFileFilter)filter).accept(fname)) continue;
            int lastDot = fname.lastIndexOf(".");
            fname = fname.substring(0, lastDot + 1) + ceff.getExtensions()[0];
            nameTF.setText(fname);
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ApproveSelection")) {
            recentPath_ = this.getCurrentDirectory();
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String pname = e.getPropertyName();
        if (pname.equals("fileFilterChanged")) {
            JTextField nameTF = this.findTextField(this);
            if (nameTF != null) {
                this.validateExtension();
            }
        } else if (pname.equals("directoryChanged")) {
            // empty if block
        }
    }
}

