/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.MouseInputAdapter;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class RgbSliderPanel
extends AbstractColorChooserPanel {
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final Color SHADOW = new Color(51, 51, 51);
    private static final Color HIGHLIGHT = new Color(153, 153, 153);
    private static ImageIcon tickIcon;
    private static Image tickImage;
    private static int tickIconWidth;
    private static int tickIconHeight;
    private RgbTextField rField;
    private RgbTextField gField;
    private RgbTextField bField;

    public RgbSliderPanel() {
        this.setOpaque(false);
        if (tickIcon == null) {
            tickIcon = new ImageIcon(RgbSliderPanel.class.getResource("resources/slidertick.png"));
            tickImage = tickIcon.getImage();
        }
        JLabel rLabel = new JLabel("R", 4);
        JLabel gLabel = new JLabel("G", 4);
        JLabel bLabel = new JLabel("B", 4);
        rLabel.setFont(rLabel.getFont().deriveFont((float)((double)rLabel.getFont().getSize() - 3.0)));
        gLabel.setFont(rLabel.getFont());
        bLabel.setFont(rLabel.getFont());
        this.rField = new RgbTextField(0);
        this.gField = new RgbTextField(1);
        this.bField = new RgbTextField(2);
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(8, 5), 2, 12);
        fgl.setColumnWeight(0, 9999.0f);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setColumnWeight(7, 9999.0f);
        fgl.setRowWeight(0, 9999.0f);
        fgl.setRowWeight(4, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)new ColorBox(), new Rectangle(1, 1, 1, 3));
        this.add((Component)rLabel, new Rectangle(3, 1, 1, 1));
        this.add((Component)gLabel, new Rectangle(3, 2, 1, 1));
        this.add((Component)bLabel, new Rectangle(3, 3, 1, 1));
        this.add((Component)new Slider(0), new FGConstraint(new Rectangle(4, 1, 1, 1), 0.5, 0.5));
        this.add((Component)new Slider(1), new FGConstraint(new Rectangle(4, 2, 1, 1), 0.5, 0.5));
        this.add((Component)new Slider(2), new FGConstraint(new Rectangle(4, 3, 1, 1), 0.5, 0.5));
        this.add((Component)this.rField, new FGConstraint(new Rectangle(5, 1, 1, 1), 0.5, 0.5));
        this.add((Component)this.gField, new FGConstraint(new Rectangle(5, 2, 1, 1), 0.5, 0.5));
        this.add((Component)this.bField, new FGConstraint(new Rectangle(5, 3, 1, 1), 0.5, 0.5));
        this.add(Box.createGlue(), new Rectangle(0, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(2, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(7, 4, 1, 1));
    }

    public Color getColor() {
        return this.getColorSelectionModel().getSelectedColor();
    }

    public void setColor(Color c) {
        this.getColorSelectionModel().setSelectedColor(c);
        this.rField.refresh();
        this.gField.refresh();
        this.bField.refresh();
        this.repaint();
    }

    private void setRgb(int which, int value) {
        Color c = this.getColorSelectionModel().getSelectedColor();
        try {
            if (which == 0) {
                c = new Color(value, c.getGreen(), c.getBlue());
            } else if (which == 1) {
                c = new Color(c.getRed(), value, c.getBlue());
            } else if (which == 2) {
                c = new Color(c.getRed(), c.getGreen(), value);
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.setColor(c);
    }

    public void buildChooser() {
    }

    public void updateChooser() {
        this.rField.refresh();
        this.gField.refresh();
        this.bField.refresh();
        this.repaint();
    }

    public String getDisplayName() {
        return "RGB Sliders";
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    private class Slider
    extends JComponent {
        private int whichRgb_;
        private MouseInputAdapter mouseListener;
        private int barWidth = 128;
        private int barHeight = 5;
        private int barLeft;
        private int barTop;
        private int barBottom;
        private int pad = 6;
        private int tickWidth2;
        private int tickHeight2;

        Slider(int which) {
            this.whichRgb_ = which;
            this.setOpaque(false);
            if (tickIconWidth == 0) {
                tickIconWidth = tickIcon.getIconWidth();
                tickIconHeight = tickIcon.getIconHeight();
            }
            Dimension size = new Dimension(this.barWidth + 2 * (this.pad + 1), this.barHeight + 8);
            this.setPreferredSize(size);
            this.mouseListener = new SliderMouseHandler();
            this.addMouseListener(this.mouseListener);
            this.addMouseMotionListener(this.mouseListener);
        }

        public void paintComponent(Graphics g) {
            int h = this.getHeight();
            int w = this.getWidth();
            this.barHeight = h / 3;
            this.tickHeight2 = 12;
            this.tickWidth2 = 12;
            this.barWidth = w - 2 * (this.pad + 1);
            this.barLeft = this.pad + 1;
            this.barTop = (h - 16) / 2 + this.barHeight;
            this.barBottom = this.barTop + this.barHeight + 1;
            g.setColor(SHADOW);
            g.drawLine(this.pad + 0, this.barTop, this.pad + 1 + this.barWidth, this.barTop);
            g.drawLine(this.pad + 0, this.barTop, this.pad + 0, this.barBottom);
            g.setColor(HIGHLIGHT);
            g.drawLine(this.pad + 1, this.barBottom, this.pad + 1 + this.barWidth, this.barBottom);
            g.drawLine(this.pad + 1 + this.barWidth, this.barTop + 1, this.pad + 1 + this.barWidth, this.barBottom);
            Color c = RgbSliderPanel.this.getColorSelectionModel().getSelectedColor();
            for (int i = 0; i < this.barWidth; ++i) {
                int ii = (int)(255.0 * (double)i / (double)this.barWidth);
                if (this.whichRgb_ == 0) {
                    g.setColor(new Color(ii, c.getGreen(), c.getBlue()));
                } else if (this.whichRgb_ == 1) {
                    g.setColor(new Color(c.getRed(), ii, c.getBlue()));
                } else if (this.whichRgb_ == 2) {
                    g.setColor(new Color(c.getRed(), c.getGreen(), ii));
                }
                g.drawLine(this.pad + 1 + i, this.barTop + 1, this.pad + 1 + i, this.barTop + this.barHeight);
            }
            g.drawImage(tickImage, this.pad + 1 + this.getTickX() - this.tickWidth2 / 2, (this.barTop + this.barBottom - this.tickHeight2) / 2, this.tickWidth2, this.tickHeight2, new Color(0, 0, 0, 0), RgbSliderPanel.this);
        }

        private int getTickX() {
            Color c = RgbSliderPanel.this.getColorSelectionModel().getSelectedColor();
            if (this.whichRgb_ == 0) {
                return (int)((double)this.barWidth * (double)c.getRed() / 255.0);
            }
            if (this.whichRgb_ == 1) {
                return (int)((double)this.barWidth * (double)c.getGreen() / 255.0);
            }
            if (this.whichRgb_ == 2) {
                return (int)((double)this.barWidth * (double)c.getBlue() / 255.0);
            }
            return 0;
        }

        public boolean isFocusable() {
            return false;
        }

        private class SliderMouseHandler
        extends MouseInputAdapter {
            boolean dragInProgress = false;

            SliderMouseHandler() {
            }

            public void mouseClicked(MouseEvent e) {
                int tick = Slider.this.getTickX();
                int x = e.getX() - Slider.this.pad;
                int y = e.getY();
                if (x < tick - Slider.this.tickWidth2 / 2 || x > tick + Slider.this.tickWidth2 / 2 || x < 0 || x > Slider.this.barWidth) {
                    return;
                }
                this.handleMouse(e);
            }

            public void mousePressed(MouseEvent e) {
                this.mouseClicked(e);
                this.dragInProgress = true;
            }

            public void mouseReleased(MouseEvent e) {
                if (!this.dragInProgress) {
                    return;
                }
                this.handleMouse(e);
                this.dragInProgress = false;
            }

            public void mouseDragged(MouseEvent e) {
                if (!this.dragInProgress) {
                    return;
                }
                this.handleMouse(e);
            }

            public void handleMouse(MouseEvent e) {
                int x = e.getX() - Slider.this.pad - 1;
                int value = (int)(255.0 * (double)x / (double)Slider.this.barWidth);
                RgbSliderPanel.this.setRgb(Slider.this.whichRgb_, value);
            }
        }
    }

    private class RgbTextField
    extends JTextField {
        private int whichRgb_;

        RgbTextField(int which) {
            super(4);
            this.setFont(this.getFont().deriveFont((float)((double)this.getFont().getSize() - 2.0)));
            this.whichRgb_ = which;
            this.setText("255");
            this.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    RgbTextField.this.respond();
                }

                public void focusGained(FocusEvent e) {
                }
            });
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RgbTextField.this.respond();
                }
            });
        }

        private void refresh() {
            ColorSelectionModel csm = RgbSliderPanel.this.getColorSelectionModel();
            if (csm == null) {
                return;
            }
            Color c = csm.getSelectedColor();
            if (this.whichRgb_ == 0) {
                this.setText(Integer.toString(c.getRed()));
            } else if (this.whichRgb_ == 1) {
                this.setText(Integer.toString(c.getGreen()));
            } else if (this.whichRgb_ == 2) {
                this.setText(Integer.toString(c.getBlue()));
            }
        }

        private void respond() {
            try {
                RgbSliderPanel.this.setRgb(this.whichRgb_, Integer.parseInt(this.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.refresh();
        }
    }

    private class ColorBox
    extends JComponent {
        ColorBox() {
            Dimension size = new Dimension(34, 34);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
        }

        public void paintComponent(Graphics g) {
            int h = this.getHeight();
            int w = this.getWidth();
            int l = (w - 34) / 2;
            int t = (h - 34) / 2;
            g.setColor(SHADOW);
            g.drawLine(l, t, l + 34, t);
            g.drawLine(l, t, l, t + 34);
            g.setColor(HIGHLIGHT);
            g.drawLine(l + 1, t + 34, l + 1 + 32, t + 34);
            g.drawLine(l + 34, t + 1, l + 34, t + 34);
            g.setColor(RgbSliderPanel.this.getColorSelectionModel().getSelectedColor());
            g.fillRect(l + 1, t + 1, 32, 32);
        }

        public boolean isFocusable() {
            return false;
        }
    }
}

