/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.color;

import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.gui.plaf.GissComboBoxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JList;

public class ColorTableComboBoxRenderer
extends GissComboBoxRenderer {
    private static final int SAMPLE_WIDTH = 48;
    private AbstractColorTable ctable_;

    public void setColorTable(AbstractColorTable c) {
        this.ctable_ = c;
        this.text_ = this.ctable_ == null ? " " : this.ctable_.toString();
        this.measured_ = false;
        this.repaint();
    }

    protected void paintContent(Graphics2D g2d, int xOffset) {
        int x = xOffset;
        Dimension size = this.getSize();
        Insets ins = this.getInsets();
        Color fgcolor = this.getForeground();
        Color bgcolor = this.getBackground();
        if (this.ctable_ != null) {
            int colorCount = this.ctable_.getColorCount();
            double binwidth1 = 48.0 / (double)colorCount;
            int binwidth2 = (int)Math.round(binwidth1) + 1;
            int barHeight = this.getFont().getSize() - 2;
            int barTop = (size.height - barHeight) / 2;
            for (int i = 0; i < colorCount; ++i) {
                if (this.isEnabled()) {
                    g2d.setColor(this.ctable_.getColorAt(i));
                } else {
                    Color c1 = this.ctable_.getColorAt(i);
                    Color c2 = bgcolor;
                    g2d.setColor(new Color((c1.getRed() + 9 * c2.getRed()) / 10, (c1.getGreen() + 9 * c2.getGreen()) / 10, (c1.getBlue() + 9 * c2.getBlue()) / 10));
                }
                g2d.fillRect((int)((double)x + binwidth1 * (double)i) + 1, barTop, binwidth2, barHeight);
            }
            g2d.setColor(fgcolor);
            g2d.drawRect(x, barTop, 49, barHeight);
            x += 54;
        }
        g2d.setColor(fgcolor);
        g2d.drawString(this.text_, x, (size.height - this.lineHeight_) / 2 + this.lineAscent_);
    }

    protected synchronized void measure() {
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        this.lineHeight_ = fm.getHeight();
        this.lineAscent_ = fm.getAscent();
        this.prefWidth_ = this.ctable_ == null ? 54 + fm.stringWidth(this.text_) : 54 + fm.stringWidth(this.text_);
        this.prefHeight_ = this.lineHeight_ + 2;
        if (this.isOffset_) {
            this.prefWidth_ += 2 + iconWidth_ + 6;
        }
        this.measured_ = true;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value == null) {
            this.setColorTable(null);
            this.setText("");
        } else if (value instanceof AbstractColorTable) {
            this.setColorTable((AbstractColorTable)value);
        } else {
            this.setColorTable(null);
            this.setText(value.toString());
        }
        return this;
    }
}

