/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.color;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.color.ColorMenu;
import gov.nasa.giss.gui.color.PaletteType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;

class ColorMenuPopup
extends JPopupMenu {
    private static final int BIN_MARGIN = 3;
    private ColorMenu parentCB_;
    private ColorPanel cpanel_;
    private PaletteType ptype_;
    private Color[] colors_;
    private Color selColor_ = Color.BLACK;
    private int selBin_ = 0;
    private int overBin_ = -1;
    private int columns_ = 32;
    private int rows_ = 9;
    private int binCount_ = this.columns_ * this.rows_;
    private int binSize_ = 12;
    private int fullBinSize_ = this.binSize_ + 6;

    public ColorMenuPopup(ColorMenu parent, PaletteType ptype) {
        this.parentCB_ = parent;
        this.ptype_ = ptype;
        if (this.ptype_ == PaletteType.GRAYSCALE) {
            this.columns_ = 2;
            this.rows_ = 9;
            this.binSize_ = 14;
        } else if (this.ptype_ == PaletteType.BLACK_WHITE) {
            this.columns_ = 2;
            this.rows_ = 1;
            this.binSize_ = 18;
        } else {
            this.columns_ = 32;
            this.rows_ = 9;
            this.binSize_ = 12;
        }
        this.fullBinSize_ = this.binSize_ + 6;
        this.binCount_ = this.columns_ * this.rows_;
        this.colors_ = new Color[this.binCount_];
        this.cpanel_ = new ColorPanel();
        this.add(this.cpanel_);
        Insets ins = this.getInsets();
        int imax = Math.max(Math.max(ins.left, ins.top), Math.max(ins.right, ins.bottom));
        if (imax > 0) {
            Border inner = BorderFactory.createEmptyBorder(imax - ins.top, imax - ins.left, imax - ins.bottom, imax - ins.right);
            Border outer = this.getBorder();
            this.setBorder(BorderFactory.createCompoundBorder(outer, inner));
        }
        this.selBin_ = 0;
        this.selColor_ = this.getColorForBin(0);
        this.setFocusable(false);
        this.addKeyListener(new KeyResponder(1));
    }

    Point getSelectedPoint() {
        Point p = this.cpanel_.getPointForBin(this.selBin_);
        p.x += this.fullBinSize_ / 2;
        p.y += this.fullBinSize_ / 2;
        return p;
    }

    int getItemCount() {
        return this.binCount_;
    }

    int getSelectedIndex() {
        return this.selBin_;
    }

    void setSelectedIndex(int index) {
        if (index < 0 || index >= this.binCount_) {
            throw new IllegalArgumentException("ColorMenu item index out of range");
        }
        int oldBin = this.selBin_;
        Color oldColor = this.selColor_;
        this.selBin_ = index;
        this.selColor_ = this.getColorForBin(index);
        this.setVisible(false);
        this.parentCB_.colorChanged(oldBin, oldColor, this.selBin_, this.selColor_);
    }

    Color getSelectedColor() {
        return this.selColor_;
    }

    void setSelectedColor(Color c) {
        for (int i = 0; i < this.binCount_; ++i) {
            Color bc = this.getColorForBin(i);
            if (!bc.equals(c)) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    void shiftBin(int keyCode) {
        if (!this.isVisible()) {
            return;
        }
        if ((keyCode == 10 || keyCode == 32) && this.overBin_ >= 0) {
            this.setSelectedIndex(this.overBin_);
        }
        if (keyCode != 40 && keyCode != 38 && keyCode != 37 && keyCode != 39) {
            return;
        }
        if (this.overBin_ < 0) {
            this.overBin_ = keyCode == 40 || keyCode == 39 ? 0 : this.binCount_ - 1;
        } else {
            int current = this.overBin_;
            int row = current / this.columns_;
            int col = current % this.columns_;
            if (keyCode == 40) {
                ++row;
            } else if (keyCode == 38) {
                --row;
            } else {
                col = keyCode == 39 ? ++col : --col;
            }
            if (row < 0) {
                row = 0;
            }
            if (col < 0) {
                col = 0;
            }
            if (row >= this.rows_) {
                row = this.rows_ - 1;
            }
            if (col >= this.columns_) {
                col = this.columns_ - 1;
            }
            this.overBin_ = row * this.columns_ + col;
        }
        this.repaint();
    }

    private Color getColorForBin(int bin) {
        if (bin < 0 || bin > this.colors_.length) {
            return null;
        }
        if (this.colors_[bin] != null) {
            return this.colors_[bin];
        }
        int row = bin / this.columns_;
        int col = bin % this.columns_;
        return this.getColorForBin(col, row);
    }

    private Color getColorForBin(int col, int row) {
        int bin = row * this.columns_ + col;
        if (this.colors_[bin] != null) {
            return this.colors_[bin];
        }
        if (col == 0) {
            int rgb = row * 16;
            this.colors_[bin] = new Color(rgb, rgb, rgb);
        } else if (col == 1) {
            int rgb = 255 - row * 16;
            this.colors_[bin] = new Color(rgb, rgb, rgb);
        } else {
            int gg = (col - 2) / 5;
            int ggc = (col - 2) % 5;
            int ggp1 = gg + 1;
            int ggr1 = gg < 2 || gg > 4 ? 255 : 0;
            int ggg1 = gg > 0 && gg < 4 ? 255 : 0;
            int ggb1 = gg > 2 ? 255 : 0;
            int ggr2 = ggp1 < 2 || ggp1 > 4 ? 255 : 0;
            int ggg2 = ggp1 > 0 && ggp1 < 4 ? 255 : 0;
            int ggb2 = ggp1 > 2 && ggp1 < 6 ? 255 : 0;
            int ggr1a = ggr1;
            int ggg1a = ggg1;
            int ggb1a = ggb1;
            int ggr2a = ggr2;
            int ggg2a = ggg2;
            int ggb2a = ggb2;
            if (row < 4) {
                ggr1a = Math.max(0, Math.min(255, ggr1 + 51 * (4 - row)));
                ggg1a = Math.max(0, Math.min(255, ggg1 + 51 * (4 - row)));
                ggb1a = Math.max(0, Math.min(255, ggb1 + 51 * (4 - row)));
                ggr2a = Math.max(0, Math.min(255, ggr2 + 51 * (4 - row)));
                ggg2a = Math.max(0, Math.min(255, ggg2 + 51 * (4 - row)));
                ggb2a = Math.max(0, Math.min(255, ggb2 + 51 * (4 - row)));
            } else if (row > 4) {
                ggr1a = Math.max(0, Math.min(255, ggr1 - 51 * (4 - row)));
                ggg1a = Math.max(0, Math.min(255, ggg1 - 51 * (4 - row)));
                ggb1a = Math.max(0, Math.min(255, ggb1 - 51 * (4 - row)));
                ggr2a = Math.max(0, Math.min(255, ggr2 - 51 * (4 - row)));
                ggg2a = Math.max(0, Math.min(255, ggg2 - 51 * (4 - row)));
                ggb2a = Math.max(0, Math.min(255, ggb2 - 51 * (4 - row)));
            }
            int dir = (ggr2a - ggr1a) / 5;
            int dig = (ggg2a - ggg1a) / 5;
            int dib = (ggb2a - ggb1a) / 5;
            int r = ggr1a + ggc * dir;
            int g = ggg1a + ggc * dig;
            int b = ggb1a + ggc * dib;
            this.colors_[bin] = new Color(r, g, b);
        }
        return this.colors_[bin];
    }

    public void setVisible(boolean b) {
        this.overBin_ = this.selBin_;
        super.setVisible(b);
    }

    class KeyResponder
    extends KeyAdapter {
        int which_;

        KeyResponder(int which) {
            this.which_ = which;
        }

        public void keyPressed(KeyEvent e) {
            int kcode = e.getKeyCode();
            e.consume();
        }

        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        public void keyTyped(KeyEvent e) {
            e.consume();
        }
    }

    class ColorPanel
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        public ColorPanel() {
            this.setBorder(null);
            this.setOpaque(false);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addKeyListener(new KeyResponder(2));
        }

        public Dimension getPreferredSize() {
            return new Dimension(ColorMenuPopup.this.columns_ * ColorMenuPopup.this.fullBinSize_, ColorMenuPopup.this.rows_ * ColorMenuPopup.this.fullBinSize_);
        }

        public void paintComponent(Graphics g) {
            Color fg = UIManager.getColor("PopupMenu.foreground");
            Color selBg = UIManager.getColor("PopupMenu.selectionBackground");
            Color selFg = UIManager.getColor("PopupMenu.selectionForeground");
            if (selBg == null) {
                fg = UIManager.getColor("MenuItem.foreground");
                selBg = UIManager.getColor("MenuItem.selectionBackground");
                selFg = UIManager.getColor("MenuItem.selectionForeground");
            }
            if (ColorMenuPopup.this.overBin_ > -1) {
                Point p = this.getPointForBin(ColorMenuPopup.this.overBin_);
                GuiUtilities.fillPopupSelectionBackground(g, p.x, p.y, ColorMenuPopup.this.fullBinSize_, ColorMenuPopup.this.fullBinSize_);
            }
            for (int i = 0; i < ColorMenuPopup.this.binCount_; ++i) {
                Color c = ColorMenuPopup.this.getColorForBin(i);
                Point p = this.getPointForBin(i);
                p.x += 3;
                p.y += 3;
                g.setColor(i == ColorMenuPopup.this.overBin_ ? selFg : fg);
                g.fillRect(p.x, p.y, ColorMenuPopup.this.binSize_, ColorMenuPopup.this.binSize_);
                g.setColor(c);
                g.fillRect(p.x + 1, p.y + 1, ColorMenuPopup.this.binSize_ - 2, ColorMenuPopup.this.binSize_ - 2);
            }
        }

        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int bin = this.getBinForPoint(p);
            if (bin > -1) {
                ColorMenuPopup.this.setSelectedIndex(bin);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            Point p = e.getPoint();
            ColorMenuPopup.this.overBin_ = this.getBinForPoint(p);
            this.repaint();
        }

        private int getBinForPoint(Point p) {
            for (int iiy = 0; iiy < ColorMenuPopup.this.rows_; ++iiy) {
                for (int iix = 0; iix < ColorMenuPopup.this.columns_; ++iix) {
                    Point pbin = this.getPointForBin(iix, iiy);
                    if (p.x < pbin.x || p.x > pbin.x + ColorMenuPopup.this.fullBinSize_ || p.y < pbin.y || p.y > pbin.y + ColorMenuPopup.this.fullBinSize_) continue;
                    return iiy * ColorMenuPopup.this.columns_ + iix;
                }
            }
            return -1;
        }

        private Point getPointForBin(int bin) {
            int row = bin / ColorMenuPopup.this.columns_;
            int col = bin % ColorMenuPopup.this.columns_;
            return this.getPointForBin(col, row);
        }

        private Point getPointForBin(int col, int row) {
            int px = col * ColorMenuPopup.this.fullBinSize_;
            int py = row * ColorMenuPopup.this.fullBinSize_;
            return new Point(px, py);
        }
    }
}

