/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui.color;

import gov.nasa.giss.gui.color.ColorInfo;
import gov.nasa.giss.gui.plaf.GissComboBoxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.swing.JList;

public class ColorComboBoxRenderer
extends GissComboBoxRenderer {
    private ColorInfo item_;

    protected void paintContent(Graphics2D g2d, int xOffset) {
        int x = xOffset;
        Dimension size = this.getSize();
        Color fgcolor = this.getForeground();
        int boxSize = this.getFont().getSize() - 2;
        int boxTop = (size.height - boxSize) / 2;
        if (this.isEnabled()) {
            g2d.setColor(fgcolor);
            g2d.fillRect(x, boxTop, boxSize, boxSize);
            g2d.setColor(this.item_.getColor());
            g2d.fillRect(x, boxTop, boxSize, boxSize);
        } else {
            Color c1 = this.item_.getColor();
            g2d.setColor(new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), 51));
            g2d.fillRect(x, boxTop, boxSize, boxSize);
            g2d.setColor(new Color(fgcolor.getRed(), fgcolor.getGreen(), fgcolor.getBlue(), 51));
            g2d.drawRect(x, boxTop, boxSize, boxSize);
        }
        g2d.setColor(fgcolor);
        g2d.drawString(this.item_.getName(), x += boxSize + 4, (size.height - this.lineHeight_) / 2 + this.lineAscent_);
    }

    protected synchronized void measure() {
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        int boxSize = f.getSize() - 1;
        this.lineHeight_ = fm.getHeight();
        this.lineAscent_ = fm.getAscent();
        String text = this.item_.getName();
        this.prefWidth_ = boxSize + 4 + fm.stringWidth(text);
        this.prefHeight_ = this.lineHeight_ + 2;
        if (this.isOffset_) {
            this.prefWidth_ += 2 + iconWidth_ + 6;
        }
        this.measured_ = true;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            this.item_ = (ColorInfo)value;
        }
        this.setText("");
        return this;
    }
}

