/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import java.awt.Component;
import javax.swing.Box;

public class QuickBox
extends Box {
    public static final int NONE = 0;
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;

    protected QuickBox(int axis) {
        super(axis);
    }

    protected QuickBox(int axis, Component ... components) {
        this(axis, 0, components);
    }

    protected QuickBox(int axis, int alignment, Component ... components) {
        super(axis);
        this.setOpaque(false);
        if (axis == 0) {
            if (alignment == 3 || alignment == 1) {
                this.add(Box.createHorizontalGlue());
            }
        } else if (axis == 1 && (alignment == 5 || alignment == 1)) {
            this.add(Box.createVerticalGlue());
        }
        if (components != null) {
            for (Component c : components) {
                this.add(c);
            }
        }
        if (axis == 0) {
            if (alignment == 2 || alignment == 1) {
                this.add(Box.createHorizontalGlue());
            }
        } else if (axis == 1 && (alignment == 4 || alignment == 1)) {
            this.add(Box.createVerticalGlue());
        }
    }

    public static QuickBox createHorizontalBox(Component ... components) {
        return QuickBox.createHorizontalBox(0, components);
    }

    public static QuickBox createLeftBox(Component ... components) {
        return QuickBox.createHorizontalBox(2, components);
    }

    public static QuickBox createCenterBox(Component ... components) {
        return QuickBox.createHorizontalBox(1, components);
    }

    public static QuickBox createRightBox(Component ... components) {
        return QuickBox.createHorizontalBox(3, components);
    }

    public static QuickBox createHorizontalBox(int alignment, Component ... components) {
        if (alignment != 2 && alignment != 1 && alignment != 3 && alignment != 0) {
            throw new IllegalArgumentException("Illegal horizontal alignment");
        }
        return new QuickBox(0, alignment, components);
    }

    public static QuickBox createVerticalBox(Component ... components) {
        return QuickBox.createVerticalBox(0, components);
    }

    public static QuickBox createVerticalBox(int alignment, Component ... components) {
        if (alignment != 4 && alignment != 1 && alignment != 5 && alignment != 0) {
            throw new IllegalArgumentException("Illegal horizontal alignment");
        }
        return new QuickBox(1, alignment, components);
    }

    public static QuickBox createTopBox(Component ... components) {
        return QuickBox.createVerticalBox(4, components);
    }

    public static QuickBox createMiddleBox(Component ... components) {
        return QuickBox.createVerticalBox(1, components);
    }

    public static QuickBox createBottomBox(Component ... components) {
        return QuickBox.createVerticalBox(5, components);
    }
}

