/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import gov.nasa.giss.gui.menu.GissMenuBar;
import gov.nasa.giss.gui.tabbedpane.FolderTabbedPane;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public final class GuiUtilities {
    private static final Color GRAPHITE_FOCUS_COLOR = new Color(94, 107, 121);

    private GuiUtilities() {
    }

    public static JFrame getActiveFrame() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (kfm == null) {
            return null;
        }
        Window front = kfm.getActiveWindow();
        if (!(front instanceof JFrame)) {
            return null;
        }
        return (JFrame)front;
    }

    public static JFrame getParentFrame(JComponent jc) {
        Component c2;
        Container c1;
        Container tla = jc.getTopLevelAncestor();
        if (tla == null && (c1 = jc.getParent()) instanceof JPopupMenu && (c2 = ((JPopupMenu)c1).getInvoker()) != null && c1 instanceof JComponent) {
            tla = ((JComponent)c2).getTopLevelAncestor();
        }
        if (tla == null || !(tla instanceof JFrame)) {
            return null;
        }
        return (JFrame)tla;
    }

    public static Window getParentWindow(JComponent jc) {
        Component c2;
        Container c1;
        Container tla = jc.getTopLevelAncestor();
        if (tla == null && (c1 = jc.getParent()) instanceof JPopupMenu && (c2 = ((JPopupMenu)c1).getInvoker()) != null && c1 instanceof JComponent) {
            tla = ((JComponent)c2).getTopLevelAncestor();
        }
        if (tla == null || !(tla instanceof Window)) {
            return null;
        }
        return (Window)tla;
    }

    public static void refreshFrontFrameMenuBar() {
        final JFrame front = GuiUtilities.getActiveFrame();
        if (front == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JMenuBar mbar = front.getJMenuBar();
                if (mbar != null && mbar instanceof GissMenuBar) {
                    ((GissMenuBar)mbar).refresh();
                }
            }
        });
    }

    public static boolean applyBrushMetalLook(JFrame frame) {
        if (PlatformUtilities.isMacintosh()) {
            frame.getRootPane().putClientProperty("apple.awt.brushMetalLook", Boolean.TRUE);
            return true;
        }
        return false;
    }

    public static Rectangle getMainScreenBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        if (gc == null) {
            return null;
        }
        return gc.getBounds();
    }

    public static void padBorder(JComponent jc, int top, int left, int bottom, int right) {
        Border innerBorder = jc.getBorder();
        Border outerBorder = BorderFactory.createEmptyBorder(top, left, bottom, right);
        jc.setBorder(new CompoundBorder(outerBorder, innerBorder));
    }

    public static CompoundBorder createPaddedTitleBorder(String s) {
        TitledBorder outerBorder = BorderFactory.createTitledBorder(s);
        Border innerBorder = BorderFactory.createEmptyBorder(2, 4, 4, 4);
        return new CompoundBorder(outerBorder, innerBorder);
    }

    public static CompoundBorder createPaddedHudTitleBorder(String s) {
        TitledBorder outerBorder = new TitledBorder(s);
        Border innerBorder = BorderFactory.createEmptyBorder(2, 4, 4, 4);
        outerBorder.setTitleColor(Color.WHITE);
        return new CompoundBorder(outerBorder, innerBorder);
    }

    public static boolean isParentWindowFocused(Component c) {
        Window window = SwingUtilities.getWindowAncestor(c);
        return window != null && window.isFocused();
    }

    public static void setSizeRegular(JComponent jc) {
        GuiUtilities.setSizeVariant(jc, SizeVariant.REGULAR);
    }

    public static void setSizeRegular(Border border) {
        GuiUtilities.setSizeVariant(border, SizeVariant.REGULAR);
    }

    public static void setSizeSmall(JComponent jc) {
        GuiUtilities.setSizeVariant(jc, SizeVariant.SMALL);
    }

    public static void setSizeSmall(Border border) {
        GuiUtilities.setSizeVariant(border, SizeVariant.SMALL);
    }

    public static void setSizeMini(JComponent jc) {
        GuiUtilities.setSizeVariant(jc, SizeVariant.MINI);
    }

    public static void setSizeMini(Border border) {
        GuiUtilities.setSizeVariant(border, SizeVariant.MINI);
    }

    private static void setSizeVariant(JComponent jc, SizeVariant size) {
        if (jc == null) {
            return;
        }
        for (Component c : jc.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            GuiUtilities.setSizeVariant((JComponent)c, size);
        }
        if (PlatformUtilities.isMacintosh()) {
            if (jc instanceof JSpinner) {
                JComponent jce = ((JSpinner)jc).getEditor();
                if (jce instanceof JSpinner.DefaultEditor) {
                    JFormattedTextField jtf = ((JSpinner.DefaultEditor)jce).getTextField();
                    GuiUtilities.setSizeVariant(jtf, size);
                } else {
                    GuiUtilities.setSizeVariant(jce, size);
                }
            }
            if (jc instanceof JTable || jc instanceof JTabbedPane && !(jc instanceof FolderTabbedPane)) {
                double multiple = 1.0;
                if (size == SizeVariant.SMALL) {
                    multiple = 0.9;
                } else if (size == SizeVariant.MINI) {
                    multiple = 0.9;
                }
                Font f = jc.getFont();
                if (f != null) {
                    float fsize = (float)Math.floor(multiple * (double)f.getSize());
                    jc.setFont(f.deriveFont(fsize));
                }
            } else {
                String value = "regular";
                if (size == SizeVariant.SMALL) {
                    value = "small";
                } else if (size == SizeVariant.MINI) {
                    value = "mini";
                }
                jc.putClientProperty("JComponent.sizeVariant", value);
            }
        }
        if (jc instanceof JTextField || jc instanceof JSpinner || jc instanceof JComboBox || jc instanceof JLabel || jc instanceof JCheckBox || jc instanceof JButton || jc instanceof JToggleButton) {
            GuiUtilities.restrictSize(jc);
        }
    }

    public static void restrictSize(JComponent jc) {
        jc.setPreferredSize(null);
        jc.setMinimumSize(jc.getPreferredSize());
        jc.setMaximumSize(jc.getPreferredSize());
    }

    private static void setSizeVariant(Border border, SizeVariant size) {
        if (PlatformUtilities.isMacintosh()) {
            if (border == null) {
                return;
            }
            if (border instanceof TitledBorder) {
                TitledBorder tb = (TitledBorder)border;
                Font f = tb.getTitleFont();
                if (f != null) {
                    tb.setTitleFont(f.deriveFont((float)(f.getSize() - 2)));
                }
            } else if (border instanceof CompoundBorder) {
                CompoundBorder cb = (CompoundBorder)border;
                GuiUtilities.setSizeVariant(cb.getOutsideBorder(), size);
                GuiUtilities.setSizeVariant(cb.getInsideBorder(), size);
            }
        }
    }

    public static void reduceComponentFont(Component component, int reduction) {
        Font f;
        if (PlatformUtilities.isMacintosh() && (f = component.getFont()) != null) {
            component.setFont(f.deriveFont((float)(f.getSize() - reduction)));
        }
    }

    public static void fillPopupSelectionBackground(Graphics g, int x, int y, int width, int height) {
        if (PlatformUtilities.isMacintosh()) {
            Color selBg = UIManager.getColor("Focus.color");
            Graphics2D g2d = (Graphics2D)g;
            if (selBg.equals(GRAPHITE_FOCUS_COLOR)) {
                GradientPaint paint = new GradientPaint(x + 1, y, new Color(129, 136, 143), x + 1, y + height, new Color(110, 118, 129));
                g2d.setPaint(paint);
                g2d.fillRect(x, y, width, height);
                g.setColor(new Color(117, 124, 132));
                g.drawLine(x, y, x + width - 1, y);
                g.setColor(new Color(93, 103, 114));
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            } else {
                GradientPaint paint = new GradientPaint(x, y, new Color(112, 133, 247), x, y + height, new Color(67, 88, 244));
                g2d.setPaint(paint);
                g2d.fillRect(x, y, width, height);
                g.setColor(new Color(102, 122, 237));
                g.drawLine(x, y, x + width - 1, y);
                g.setColor(new Color(58, 75, 236));
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            }
        } else {
            Color selBg = UIManager.getColor("PopupMenu.selectionBackground");
            if (selBg == null) {
                selBg = UIManager.getColor("MenuItem.selectionBackground");
            }
            g.setColor(selBg);
            g.fillRect(x, y, width, height);
        }
    }

    public static void updateGraphicsIfDisabled(Graphics2D g2d, Component component) {
        if (!component.isEnabled()) {
            g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
    }

    public static void makeRecursiveDropTarget(Component component, DropTargetListener listener) {
        DropTarget dt = new DropTarget(component, listener);
        if (component instanceof Container) {
            for (Component c : ((Container)component).getComponents()) {
                GuiUtilities.makeRecursiveDropTarget(c, listener);
            }
        }
    }

    public static void showSlowMessage(final Component parent, final String title, final String message) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                String messageX = null;
                int colon = message.indexOf(": ");
                messageX = colon > -1 ? message.substring(colon + 2) : message;
                JOptionPane.showMessageDialog(parent, message, title, 0);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SizeVariant {
        REGULAR,
        SMALL,
        MINI;

    }
}

