/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import com.explodingpixels.painter.FocusStatePainter;
import com.explodingpixels.painter.GradientPainter;
import com.explodingpixels.painter.Painter;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JFrame;

public final class BrushMetalUtilities {
    private static final Color LEOPARD_BORDER_HIGHLIGHT_COLOR = new Color(255, 255, 255, 110);
    private static final Color LEOPARD_ACTIVE_TOP_COLOR = new Color(187, 187, 187);
    private static final Color LEOPARD_ACTIVE_BOTTOM_COLOR = new Color(150, 150, 150);
    private static final Color LEOPARD_INACTIVE_TOP_COLOR = new Color(227, 227, 227);
    private static final Color LEOPARD_INACTIVE_BOTTOM_COLOR = new Color(207, 207, 207);
    private static final Color LEOPARD_ACTIVE_SHADOW_COLOR = new Color(64, 64, 64);
    private static final Color LEOPARD_INACTIVE_SHADOW_COLOR = new Color(135, 135, 135);
    private static final Color BORDER_HIGHLIGHT_COLOR = new Color(255, 255, 255, 100);
    private static final Color ACTIVE_TOP_COLOR = new Color(200, 200, 200);
    private static final Color ACTIVE_BOTTOM_COLOR = new Color(167, 167, 167);
    private static final Color INACTIVE_TOP_COLOR = new Color(233, 233, 233);
    private static final Color INACTIVE_BOTTOM_COLOR = new Color(216, 216, 216);
    private static final Color ACTIVE_SHADOW_COLOR = new Color(86, 86, 86);
    private static final Color INACTIVE_SHADOW_COLOR = new Color(153, 153, 153);
    private static Painter painter_;

    private BrushMetalUtilities() {
    }

    public static void paintBrushMetalBackground(Component c, Graphics g) {
        JComponent jc = (JComponent)c;
        JFrame parent = GuiUtilities.getParentFrame(jc);
        Object o = parent.getRootPane().getClientProperty("apple.awt.brushMetalLook");
        if (o != null && o instanceof Boolean && ((Boolean)o).booleanValue()) {
            return;
        }
        Painter painter = BrushMetalUtilities.getBrushMetalPainter();
        if (painter != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            painter.paint(g2d, c, c.getWidth(), c.getHeight());
            g2d.dispose();
        }
    }

    public static Color getHighlightColor() {
        if (PlatformUtilities.isMacLeopard()) {
            return LEOPARD_BORDER_HIGHLIGHT_COLOR;
        }
        return BORDER_HIGHLIGHT_COLOR;
    }

    public static Color getShadowColor(boolean focused) {
        if (focused) {
            return PlatformUtilities.isMacLeopard() ? LEOPARD_ACTIVE_SHADOW_COLOR : ACTIVE_SHADOW_COLOR;
        }
        return PlatformUtilities.isMacLeopard() ? LEOPARD_INACTIVE_SHADOW_COLOR : INACTIVE_SHADOW_COLOR;
    }

    public static Painter getBrushMetalPainter() {
        if (painter_ != null) {
            return painter_;
        }
        if (!PlatformUtilities.isMacintosh()) {
            return null;
        }
        if (PlatformUtilities.isMacLeopard()) {
            GradientPainter focusedPainter = new GradientPainter(LEOPARD_ACTIVE_TOP_COLOR, LEOPARD_ACTIVE_BOTTOM_COLOR);
            GradientPainter unfocusedPainter = new GradientPainter(LEOPARD_INACTIVE_TOP_COLOR, LEOPARD_INACTIVE_BOTTOM_COLOR);
            painter_ = new FocusStatePainter(focusedPainter, focusedPainter, unfocusedPainter);
        } else {
            GradientPainter focusedPainter = new GradientPainter(ACTIVE_TOP_COLOR, ACTIVE_BOTTOM_COLOR);
            GradientPainter unfocusedPainter = new GradientPainter(INACTIVE_TOP_COLOR, INACTIVE_BOTTOM_COLOR);
            painter_ = new FocusStatePainter(focusedPainter, focusedPainter, unfocusedPainter);
        }
        return painter_;
    }
}

