/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import gov.nasa.giss.gui.BrushMetalBox;
import gov.nasa.giss.gui.BrushMetalUtilities;
import gov.nasa.giss.gui.WindowDragger;
import gov.nasa.giss.gui.border.FocusStateMatteBorder;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class BrushMetalToolBar
extends BrushMetalBox {
    private static Border innerBorder_;
    private static FocusStateMatteBorder outerBorder_;

    public BrushMetalToolBar() {
        this(0);
    }

    public BrushMetalToolBar(int alignment) {
        super(alignment);
        if (innerBorder_ == null) {
            Color focusedColor = BrushMetalUtilities.getShadowColor(true);
            Color unfocusedColor = BrushMetalUtilities.getShadowColor(false);
            innerBorder_ = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            outerBorder_ = new FocusStateMatteBorder(0, 0, 1, 0, focusedColor, unfocusedColor);
        }
        this.setShowBottomEdge(true);
        if (PlatformUtilities.isMacintosh()) {
            WindowDragger dragger = new WindowDragger(this);
            this.addMouseListener(dragger);
            this.addMouseMotionListener(dragger);
        }
    }

    public void setShowBottomEdge(boolean show) {
        if (show) {
            super.setBorder(BorderFactory.createCompoundBorder(outerBorder_, innerBorder_));
        } else {
            super.setBorder(innerBorder_);
        }
    }
}

