/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import gov.nasa.giss.gui.BrushMetalUtilities;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.WindowDragger;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class BrushMetalBox
extends Box {
    private static final Border BORDER = BorderFactory.createEmptyBorder(8, 8, 8, 8);

    public BrushMetalBox() {
        this(1);
    }

    public BrushMetalBox(int alignment) {
        super(alignment);
        this.setBorder(BORDER);
        if (PlatformUtilities.isMacintosh()) {
            this.setOpaque(false);
            WindowDragger dragger = new WindowDragger(this);
            this.addMouseListener(dragger);
            this.addMouseMotionListener(dragger);
        } else {
            this.setOpaque(true);
            Color cc = UIManager.getColor("Panel.background");
            if (cc != null) {
                this.setBackground(cc);
            } else {
                this.setBackground(new Color(240, 240, 240));
            }
        }
    }

    protected void paintComponent(Graphics g) {
        if (PlatformUtilities.isMacintosh()) {
            JFrame parent = GuiUtilities.getParentFrame(this);
            Object o = this.getRootPane().getClientProperty("apple.awt.brushMetalLook");
            if (o == null || !((Boolean)o).booleanValue()) {
                BrushMetalUtilities.paintBrushMetalBackground(this, g);
            }
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

