/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.gui;

import gov.nasa.giss.gui.BrushMetalUtilities;
import gov.nasa.giss.gui.WindowDragger;
import gov.nasa.giss.gui.border.FocusStateMatteBorder;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public class BrushMetalBottomBar
extends JPanel {
    private static final int VERT_PADDING = 1;
    private static final int HORZ_PADDING = 5;
    private int size_;

    public BrushMetalBottomBar() {
        this(16);
    }

    public BrushMetalBottomBar(int size) {
        this.size_ = size;
        this.setOpaque(!PlatformUtilities.isMacintosh());
        this.setLayout(new BoxLayout(this, 0));
        if (PlatformUtilities.isMacintosh()) {
            WindowDragger dragger = new WindowDragger(this);
            this.addMouseListener(dragger);
            this.addMouseMotionListener(dragger);
        }
    }

    public void setSize(int size) {
        this.size_ = size;
    }

    public Dimension getPreferredSize() {
        return new Dimension(10, this.size_);
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, this.size_);
    }

    public Dimension getMaximumSize() {
        return new Dimension(5000, this.size_);
    }

    protected void paintComponent(Graphics g) {
        BrushMetalUtilities.paintBrushMetalBackground(this, g);
    }

    public Insets getInsets() {
        return new Insets(3, 5, 1, 5);
    }

    public void setBorder(Border border) {
    }

    public Border getBorder() {
        Color focusedColor = BrushMetalUtilities.getShadowColor(true);
        Color unfocusedColor = BrushMetalUtilities.getShadowColor(false);
        Color highlightColor = BrushMetalUtilities.getHighlightColor();
        FocusStateMatteBorder topDarkBorder = new FocusStateMatteBorder(1, 0, 0, 0, focusedColor, unfocusedColor);
        MatteBorder topLightBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, highlightColor);
        CompoundBorder topBorder = BorderFactory.createCompoundBorder(topDarkBorder, topLightBorder);
        Border innerBorder = BorderFactory.createEmptyBorder(1, 5, 1, 5);
        return BorderFactory.createCompoundBorder(topBorder, innerBorder);
    }
}

