/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.ps;

import gov.nasa.giss.graphics.ps.PsGraphics2D;
import gov.nasa.giss.graphics.ps.PsWriter;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Date;

public class PsDocument {
    public static final Dimension LETTER_PORTRAIT = new Dimension(612, 792);
    public static final Dimension LETTER_LANDSCAPE = new Dimension(792, 612);
    public static final Dimension A4_PORTRAIT = new Dimension(595, 842);
    public static final Dimension A4_LANDSCAPE = new Dimension(842, 595);
    private Dimension size_;
    private PsWriter writer_;
    private PsGraphics2D g2d_;
    private String title_;

    public PsDocument(Dimension size) {
        this.size_ = size;
    }

    public Dimension getSize() {
        return this.size_;
    }

    public PsGraphics2D createGraphics(boolean textAsCurves) {
        if (this.g2d_ != null) {
            return this.g2d_;
        }
        this.g2d_ = new PsGraphics2D(this, this.size_.width, this.size_.height, textAsCurves);
        return this.g2d_;
    }

    public void addWriter(PsWriter w) {
        this.writer_ = w;
    }

    public void open() {
        this.psPrintln("%!PS-Adobe-3.0 EPSF-3.0");
        this.psPrintln("%%Creator: GISSgfx PsDocument 1.0.1");
        if (this.title_ != null) {
            this.psPrintln("%%Title: " + this.title_);
        }
        this.psPrintln("%%CreationDate: " + new Date());
        this.psPrintln("%%BoundingBox: 0 0 " + this.size_.width + " " + this.size_.height);
        this.psPrintln("%%DocumentData: Clean7Bit");
        this.psPrintln("%%DocumentProcessColors: Black");
        this.psPrintln("%%ColorUsage: Color");
        this.psPrintln("%%Origin: 0 0");
        this.psPrintln("%%Pages: 1");
        this.psPrintln("%%Page: 1 1");
        this.psPrintln("%%EndComments\n");
    }

    public void close() throws IOException {
        this.psPrintln("showpage");
        this.psPrintln("%%EOF");
        this.writer_.close();
    }

    protected void psPrint(String s) {
        try {
            if (s != null) {
                this.writer_.write(s);
            }
        }
        catch (Exception exc) {
            System.out.println("ERROR: PsDocument psPrint : " + exc.toString());
        }
    }

    protected void psPrintln(String s) {
        try {
            if (s == null) {
                this.writer_.write("\n");
            } else {
                this.writer_.write(s + "\n");
            }
        }
        catch (Exception exc) {
            System.out.println("ERROR: PsDocument psPrintln : " + exc.toString());
        }
    }

    public void setTitle(String s) {
        this.title_ = s;
    }
}

