/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable.gui;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.graphics.colortable.ColorTableOutlier;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class ColorTableSamplePanel
extends JComponent {
    public static final int RECTANGLE = 1;
    public static final int TRIANGLE = 2;
    private static final Border SIMPLE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    private AbstractColorTable colortable_;
    private ColorTableOutlier outlierShape_ = ColorTableOutlier.RECTANGLE;

    public ColorTableSamplePanel(AbstractColorTable colortable) {
        this.colortable_ = colortable;
        this.setOpaque(false);
        this.setBorder(SIMPLE_OUTLINE_BORDER);
        this.setPreferredSize(new Dimension(128, 32));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(new Dimension(2000, 32));
    }

    public void setColorTable(AbstractColorTable colortable) {
        this.colortable_ = colortable;
        this.invalidate();
        this.repaint();
    }

    public void setOutlierShape(ColorTableOutlier shape) {
        this.outlierShape_ = shape;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int outlierGap;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        GraphicUtilities.antialias(g2d);
        Insets ins = this.getInsets();
        int barMaxWidth = (this.getWidth() - ins.left - ins.right) * 8 / 10;
        int colorCount_ = this.colortable_.getColorCount();
        int istep = barMaxWidth < colorCount_ ? colorCount_ / barMaxWidth + 1 : 1;
        int binWidth = barMaxWidth < colorCount_ ? 1 : barMaxWidth / colorCount_;
        int barWidth = colorCount_ / istep * binWidth;
        int barLeft = (this.getWidth() - barWidth) / 2;
        int barRight = barLeft + barWidth;
        int barTopY = ins.top + 4;
        int barHeight = this.getHeight() - ins.top - ins.bottom - 8;
        int outlierWidth = outlierGap = barHeight / 2;
        g.setColor(Color.BLACK);
        g.fillRect(barLeft - 1, barTopY - 1, barWidth + 2, barHeight + 2);
        int i = 0;
        while (i * istep < colorCount_) {
            int ibin = i * istep;
            Color c1 = this.colortable_.getColorAt(ibin);
            int iWas = i;
            boolean keepTesting = true;
            while (keepTesting && ibin < colorCount_ - istep) {
                Color c2 = this.colortable_.getColorAt(ibin + istep);
                if (c2.equals(c1)) {
                    ibin = ++i * istep;
                    continue;
                }
                keepTesting = false;
            }
            g.setColor(c1);
            g.fillRect(barLeft + binWidth * iWas, barTopY, binWidth * (i + 1 - iWas), barHeight);
            ++i;
        }
        if (this.outlierShape_ == ColorTableOutlier.RECTANGLE) {
            g.setColor(Color.BLACK);
            g.fillRect(barLeft - outlierGap - outlierWidth - 1, barTopY - 1, outlierWidth + 2, barHeight + 2);
            g.fillRect(barRight + outlierGap - 1, barTopY - 1, outlierWidth + 2, barHeight + 2);
            g.setColor(this.colortable_.getMinOutlierColor());
            g.fillRect(barLeft - outlierGap - outlierWidth, barTopY, outlierWidth, barHeight);
            g.setColor(this.colortable_.getMaxOutlierColor());
            g.fillRect(barRight + outlierGap, barTopY, outlierWidth, barHeight);
        } else {
            GeneralPath p1 = new GeneralPath();
            p1.moveTo(barLeft - outlierGap, barTopY);
            p1.lineTo(barLeft - outlierGap, barTopY + barHeight);
            p1.lineTo(barLeft - outlierGap - 2 * outlierWidth, barTopY + barHeight / 2);
            p1.lineTo(barLeft - outlierGap, barTopY);
            p1.closePath();
            g2d.setColor(this.colortable_.getMinOutlierColor(false));
            g2d.fill(p1);
            g2d.setColor(this.getForeground());
            g2d.draw(p1);
            GeneralPath p2 = new GeneralPath();
            p2.moveTo(barRight + outlierGap, barTopY);
            p2.lineTo(barRight + outlierGap, barTopY + barHeight);
            p2.lineTo(barRight + outlierGap + 2 * outlierWidth, barTopY + barHeight / 2);
            p2.lineTo(barRight + outlierGap, barTopY);
            p2.closePath();
            g2d.setColor(this.colortable_.getMaxOutlierColor(false));
            g2d.fill(p2);
            g2d.setColor(this.getForeground());
            g2d.draw(p2);
        }
    }
}

