/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable.gui;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;

public class ColorTableBinPanel
extends JComponent {
    private static final String NO_OUTLIERS = "No special outlier colors";
    private static final String LT_MIN = "min.<";
    private static final String GT_MAX = ">max.";
    private static final Color FOCUS_COLOR = UIManager.getColor("Table.focusCellForeground");
    private static final Border SIMPLE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    private static final Border HILITE_OUTLINE_BORDER = new CompoundBorder(BorderFactory.createLineBorder(FOCUS_COLOR, 1), new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    private static final Font DEFAULT_FONT = new Font("Lucida Sans", 0, 8);
    private int binInside_ = 20;
    private int binSize_ = this.binInside_ + 2;
    private int binGap_ = 4;
    private int cellSize_ = this.binSize_ + this.binGap_;
    private int binsPerRow_ = 16;
    private AbstractColorTable colortable_;
    private int colorCount_;
    private Point[] binLoci_;
    private boolean binIdsVisible_ = false;

    public ColorTableBinPanel(AbstractColorTable ct) {
        this.setFont(DEFAULT_FONT);
        this.colortable_ = ct;
        this.setOpaque(false);
        this.setBorder(SIMPLE_OUTLINE_BORDER);
        this.measure();
        BinMouseHandler mouseAdapter = new BinMouseHandler();
        this.addMouseListener(mouseAdapter);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ColorTableBinPanel.this.setBorder(SIMPLE_OUTLINE_BORDER);
            }

            @Override
            public void focusGained(FocusEvent e) {
                ColorTableBinPanel.this.setBorder(HILITE_OUTLINE_BORDER);
            }
        });
        this.attachAction(new ToggleLabelsAction(), "SPACE");
    }

    private void attachAction(AbstractAction action, String keyStroke) {
        InputMap im = this.getInputMap(2);
        ActionMap am = this.getActionMap();
        im.put(KeyStroke.getKeyStroke(keyStroke), action.getValue("Name"));
        am.put(action.getValue("Name"), action);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    private void measure() {
        this.colorCount_ = this.colortable_.getColorCount();
        Point[] pointArray = this.binLoci_ = this.colortable_.hasOutlierColors() ? new Point[this.colorCount_ + 2] : new Point[this.colorCount_];
        if (this.colorCount_ < 320) {
            this.binsPerRow_ = 16;
            this.binInside_ = 20;
            this.binGap_ = 4;
        } else {
            this.binsPerRow_ = 25;
            this.binInside_ = 16;
            this.binGap_ = 3;
        }
        this.binSize_ = this.binInside_ + 2;
        this.cellSize_ = this.binSize_ + this.binGap_;
        if (this.colorCount_ < this.binsPerRow_ * 2) {
            this.binsPerRow_ = this.colorCount_ / 2 + this.colorCount_ % 2;
        }
        int numRows = this.colorCount_ / this.binsPerRow_;
        if (this.colorCount_ % this.binsPerRow_ > 0) {
            ++numRows;
        }
        Insets ins = this.getInsets();
        int w = this.binsPerRow_ * this.cellSize_ + ins.left + ins.right;
        int h = this.colortable_.hasOutlierColors() ? (numRows + 1) * this.cellSize_ + 2 * this.binGap_ + ins.top + ins.bottom : numRows * this.cellSize_ + ins.top + ins.bottom + 2 * this.binGap_ + this.getFont().getSize();
        Dimension size = new Dimension(w, h);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        int bin = 0;
        for (int row = 0; row < numRows; ++row) {
            for (int col = 0; col < this.binsPerRow_ && (bin = row * this.binsPerRow_ + col) < this.colorCount_; ++col) {
                int x = ins.left + col * this.cellSize_ + this.binGap_ / 2;
                int y = ins.top + row * this.cellSize_ + this.binGap_ / 2;
                if (row == numRows - 1 && this.colorCount_ % this.binsPerRow_ != 0) {
                    x += this.cellSize_ * (this.binsPerRow_ - this.colorCount_ % this.binsPerRow_) / 2;
                }
                this.binLoci_[bin] = new Point(x + 1, y + 1);
            }
            if (bin >= this.colorCount_) break;
        }
        if (this.colortable_.hasOutlierColors()) {
            int xTop = ins.top + numRows * this.cellSize_ + 2 * this.binGap_;
            this.binLoci_[this.colorCount_] = new Point(w / 2 - 12 + 1 - this.binSize_, xTop);
            this.binLoci_[this.colorCount_ + 1] = new Point(w / 2 + 12 + 1, xTop);
        }
    }

    public AbstractColorTable getColorTable() {
        return this.colortable_;
    }

    public void setColorTable(AbstractColorTable cb) {
        this.colortable_ = cb;
        this.measure();
        this.invalidate();
        if (this.getTopLevelAncestor() != null) {
            ((JFrame)this.getTopLevelAncestor()).pack();
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Insets ins = this.getInsets();
        int cmax = this.colorCount_;
        g.setFont(this.getFont());
        FontMetrics fm = g.getFontMetrics();
        for (int i = 0; i < this.colorCount_; ++i) {
            Color c = this.colortable_.getColorAt(i);
            this.drawBin(g, i, c);
            if (!this.binIdsVisible_) continue;
            int lum = (c.getRed() + c.getGreen() + c.getBlue()) / 3;
            if (lum < 156) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(Color.BLACK);
            }
            String s = Integer.toString(i + 1);
            GraphicUtilities.drawString(g2d, s, this.binLoci_[i].x + (this.binInside_ - fm.stringWidth(s)) / 2, this.binLoci_[i].y + this.getFont().getSize() + 2);
        }
        g.setColor(Color.BLACK);
        if (this.colortable_.hasOutlierColors()) {
            int tTop = this.binLoci_[this.colorCount_].y + (this.binInside_ + fm.getAscent()) / 2;
            GraphicUtilities.drawString(g2d, LT_MIN, this.binLoci_[this.colorCount_].x - 5 - fm.stringWidth(LT_MIN), tTop);
            GraphicUtilities.drawString(g2d, GT_MAX, this.binLoci_[this.colorCount_ + 1].x + this.binInside_ + 5, tTop);
            this.drawBin(g, this.colorCount_, this.colortable_.getMinOutlierColor());
            this.drawBin(g, this.colorCount_ + 1, this.colortable_.getMaxOutlierColor());
        } else {
            int xTop = this.binLoci_[this.colorCount_ - 1].y + this.cellSize_ + fm.getAscent();
            GraphicUtilities.drawString(g2d, NO_OUTLIERS, (this.getWidth() - fm.stringWidth(NO_OUTLIERS)) / 2, xTop);
        }
    }

    private void drawBin(Graphics g, int bin, Color c) {
        if (bin < 0 || bin >= this.binLoci_.length) {
            return;
        }
        Point p = this.binLoci_[bin];
        g.setColor(Color.DARK_GRAY);
        g.fillRect(p.x - 1, p.y - 1, this.binInside_ + 2, this.binInside_ + 2);
        g.setColor(c);
        g.fillRect(p.x, p.y, this.binInside_, this.binInside_);
    }

    private void highlightBin(Graphics g, int bin) {
        if (bin < 0 || bin >= this.binLoci_.length) {
            return;
        }
        Window parent = SwingUtilities.getWindowAncestor(this);
        if (parent != null && parent.isFocused()) {
            g.setColor(FOCUS_COLOR);
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        g.drawRect(this.binLoci_[bin].x - 2, this.binLoci_[bin].y - 2 + 1, this.binInside_ + 3, this.binInside_ + 3);
        g.drawRect(this.binLoci_[bin].x - 3, this.binLoci_[bin].y - 3 + 1, this.binInside_ + 5, this.binInside_ + 5);
    }

    private int xyToBin(Point xy) {
        for (int i = 0; i < this.binLoci_.length; ++i) {
            if (xy.x < this.binLoci_[i].x - 1 || xy.x > this.binLoci_[i].x + this.binInside_ + 1 || xy.y < this.binLoci_[i].y - 1 || xy.y > this.binLoci_[i].y + this.binInside_ + 1) continue;
            return i;
        }
        return -1;
    }

    class ToggleLabelsAction
    extends AbstractAction {
        ToggleLabelsAction() {
            super("toggle bin labels");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorTableBinPanel.this.binIdsVisible_ = !ColorTableBinPanel.this.binIdsVisible_;
            ColorTableBinPanel.this.repaint();
        }
    }

    private class BinMouseHandler
    extends MouseInputAdapter {
        BinMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ColorTableBinPanel.this.grabFocus();
            ColorTableBinPanel.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ColorTableBinPanel.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ColorTableBinPanel.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ColorTableBinPanel.this.grabFocus();
            ColorTableBinPanel.this.repaint();
        }
    }
}

