/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import gov.nasa.giss.graphics.ColorUtilities;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.xml.EasyParser;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Vector;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class SvgGradient
extends AbstractColorTable {
    private static final int FAUX_BINS = 500;
    private boolean parsed_;

    public SvgGradient() {
        this(100);
    }

    public SvgGradient(int count) {
        this.initiateArray(count);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("SVG");
    }

    public SvgGradient(File f) throws FileNotFoundException, IOException, JDOMException, ParseException {
        if (f == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setURL(f.toURI().toURL());
        this.parseColorTable(new FileInputStream(f));
    }

    public SvgGradient(URL url) throws IOException, JDOMException, ParseException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        this.setURL(url);
        this.parseColorTable(url.openStream());
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        SvgGradient c = new SvgGradient(256);
        c.setName("Copy of " + this.getName());
        return c;
    }

    private synchronized void parseColorTable(InputStream is) throws IOException, JDOMException, ParseException {
        Document document = EasyParser.parseDocument(is);
        Element root = document.getRootElement();
        for (Element node : root.getChildren()) {
            String nodeName = node.getName();
            if (nodeName.equals("g")) {
                this.parseGroupingNode(node);
            } else if (nodeName.equals("defs")) {
                this.parseDefsNode(node);
            } else if (nodeName.equals("linearGradient") || nodeName.equals("radialGradient")) {
                this.parseGradientNode(node);
            }
            if (!this.parsed_) continue;
            return;
        }
        if (this.getColorCount() < 1) {
            throw new ParseException("No gradient found in SVG root or defs", 1);
        }
    }

    private void parseGroupingNode(Element defs) throws JDOMException, ParseException {
        for (Element node : defs.getChildren()) {
            String nodeName = node.getName();
            if (nodeName.equals("g")) {
                this.parseGroupingNode(node);
            } else if (nodeName.equals("defs")) {
                this.parseDefsNode(node);
            } else if (nodeName.equals("linearGradient") || nodeName.equals("radialGradient")) {
                this.parseGradientNode(node);
            }
            if (!this.parsed_) continue;
            return;
        }
    }

    private void parseDefsNode(Element defs) throws JDOMException, ParseException {
        for (Element node : defs.getChildren()) {
            String nodeName = node.getName();
            if (nodeName.equals("linearGradient") || nodeName.equals("radialGradient")) {
                this.parseGradientNode(node);
            }
            if (!this.parsed_) continue;
            return;
        }
    }

    private void parseGradientNode(Element gradient) throws JDOMException, ParseException {
        int i;
        Vector<Object[]> stopPoints = new Vector<Object[]>(100);
        for (Element node : gradient.getChildren()) {
            String nodeName = node.getName();
            if (!nodeName.equals("stop")) continue;
            Attribute offsetA = node.getAttribute("offset");
            Attribute rgbA = node.getAttribute("stop-color");
            Attribute alphaA = node.getAttribute("stop-opacity");
            if (offsetA == null || rgbA == null) {
                throw new ParseException("Bad stop Element", 0);
            }
            Color color = ColorUtilities.parseColor(rgbA.getValue());
            String offsetS = offsetA.getValue();
            Double offset = offsetS.indexOf("%") > -1 ? Double.valueOf(offsetS.replaceAll("\\%", "")) : Double.valueOf(Double.valueOf(offsetS) * 100.0);
            stopPoints.add(new Object[]{offset, color});
        }
        this.initiateArray(500);
        double delta = 0.2;
        int lastjj = 0;
        int jsize = stopPoints.size() - 1;
        block1: for (i = 0; i < 500; ++i) {
            double val = 0.2 * (0.5 + (double)i);
            for (int j = lastjj; j < jsize; ++j) {
                double val1 = (Double)((Object[])stopPoints.elementAt(j))[0];
                double val2 = (Double)((Object[])stopPoints.elementAt(j + 1))[0];
                if (val < val1 || val >= val2) continue;
                double pct = (val - val1) / (val2 - val1);
                Color c1 = (Color)((Object[])stopPoints.elementAt(j))[1];
                Color c2 = (Color)((Object[])stopPoints.elementAt(j + 1))[1];
                int r1 = c1.getRed();
                int r2 = c2.getRed();
                int g1 = c1.getGreen();
                int g2 = c2.getGreen();
                int b1 = c1.getBlue();
                int b2 = c2.getBlue();
                int r = (int)((double)r1 + pct * (double)(r2 - r1));
                int g = (int)((double)g1 + pct * (double)(g2 - g1));
                int b = (int)((double)b1 + pct * (double)(b2 - b1));
                this.setColorAt(i, new Color(r, g, b));
                lastjj = j;
                continue block1;
            }
        }
        for (i = 0; i < 500; ++i) {
            if (this.getColorAt(i) != null) continue;
            this.setColorAt(i, Color.LIGHT_GRAY);
        }
        this.parsed_ = true;
    }

    @Override
    public boolean saveAs(File f) throws IOException, FileNotFoundException {
        return false;
    }
}

