/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import gov.nasa.giss.graphics.colortable.AbstractBinaryColorTable;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class Pal2ColorTable
extends AbstractBinaryColorTable {
    public Pal2ColorTable(File f) throws IOException, FileNotFoundException {
        super(f, 768, 768);
    }

    public Pal2ColorTable(URL url) throws IOException, FileNotFoundException {
        super(url, 768, 768);
    }

    public Pal2ColorTable(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("PA2");
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        Pal2ColorTable c = new Pal2ColorTable(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    @Override
    public byte[] getBytes() {
        byte[] b = new byte[768];
        b[1] = 0;
        b[257] = 0;
        b[513] = 0;
        b[1] = (byte)this.getMinOutlierColor().getRed();
        b[257] = (byte)this.getMinOutlierColor().getGreen();
        b[513] = (byte)this.getMinOutlierColor().getBlue();
        b[254] = (byte)this.getMaxOutlierColor().getRed();
        b[510] = (byte)this.getMaxOutlierColor().getGreen();
        b[766] = (byte)this.getMaxOutlierColor().getBlue();
        b[255] = -1;
        b[511] = -1;
        b[767] = -1;
        for (int i = 0; i < 252; ++i) {
            Color c = this.getColorAt(i);
            b[2 + i] = (byte)c.getRed();
            b[258 + i] = (byte)c.getGreen();
            b[514 + i] = (byte)c.getBlue();
        }
        return b;
    }

    @Override
    protected void fillColorTable(byte[] b) throws IOException {
        if (b.length < 768) {
            throw new IOException("Not a valid PAL-2 color table");
        }
        this.initiateArray(252);
        for (int i = 0; i < 252; ++i) {
            this.setColorAt(i, new Color(0xFF & b[i + 2], 0xFF & b[i + 256 + 2], 0xFF & b[i + 512 + 2]));
        }
        this.setMinOutlierColor(new Color(0xFF & b[1], 0xFF & b[257], 0xFF & b[513]));
        this.setMaxOutlierColor(new Color(0xFF & b[254], 0xFF & b[510], 0xFF & b[766]));
    }
}

