/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import gov.nasa.giss.graphics.ColorUtilities;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class GmtColorTable
extends AbstractColorTable {
    private static final int FAUX_BINS = 500;
    private Model model_ = Model.RGB;
    private boolean scale100_;

    public GmtColorTable() {
        this(100);
    }

    public GmtColorTable(int count) {
        this.initiateArray(count);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("CPT");
    }

    public GmtColorTable(File f) throws IOException, FileNotFoundException, ParseException {
        if (f == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setURL(f.toURI().toURL());
        this.parseColorTable(new BufferedReader(new FileReader(f)));
    }

    public GmtColorTable(URL url) throws IOException, FileNotFoundException, ParseException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        this.setURL(url);
        this.parseColorTable(new BufferedReader(new InputStreamReader(new BufferedInputStream(url.openStream()))));
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        GmtColorTable c = new GmtColorTable(256);
        c.setName("Copy of " + this.getName());
        return c;
    }

    private void parseColorTable(BufferedReader bReader) throws IOException, ParseException {
        int i;
        String oneLine;
        Color bColor = null;
        Color fColor = null;
        Color nColor = null;
        Vector<Object[]> segments = new Vector<Object[]>(100);
        int linesRead = 0;
        while ((oneLine = bReader.readLine()) != null) {
            ++linesRead;
            if (oneLine.startsWith("#")) {
                if (oneLine.indexOf("COLOR_MODEL") == -1) continue;
                if (oneLine.indexOf("CMYK") > -1) {
                    this.model_ = Model.CMYK;
                    continue;
                }
                if (oneLine.indexOf("HSV") > -1) {
                    this.model_ = Model.HSV;
                    continue;
                }
                if (oneLine.indexOf("RGB") != -1) continue;
                throw new ParseException("CPT file uses unknown color model.", linesRead);
            }
            int comment = Math.min(oneLine.indexOf(";"), oneLine.indexOf("#"));
            if (comment > 0) {
                oneLine = oneLine.substring(0, comment - 1);
            }
            oneLine = oneLine.replaceFirst("^\\s+", "");
            String[] tokens = (oneLine = oneLine.replaceFirst("\\s+$", "")).split("\\s+");
            int numTokens = tokens.length;
            if (numTokens < 1 || numTokens == 1 && tokens[0].length() == 0) continue;
            try {
                double v2;
                if (tokens[0].equals("B") || tokens[0].equals("F") || tokens[0].equals("N")) {
                    Object c;
                    if (numTokens == 2) {
                        c = this.lookupColor(tokens[1]);
                    } else if (numTokens == 5 && this.model_ == Model.CMYK) {
                        c = this.getCMYKColor(tokens[1], tokens[2], tokens[3], tokens[4]);
                    } else if (numTokens == 4 && this.model_ == Model.RGB) {
                        c = this.getRGBColor(tokens[1], tokens[2], tokens[3]);
                    } else if (numTokens == 4 && this.model_ == Model.HSV) {
                        c = this.getHSVColor(tokens[1], tokens[2], tokens[3]);
                    } else {
                        throw new Exception("Bad token count: " + numTokens);
                    }
                    if (tokens[0].equals("B")) {
                        bColor = c;
                        continue;
                    }
                    if (tokens[0].equals("F")) {
                        fColor = c;
                        continue;
                    }
                    nColor = c;
                    continue;
                }
                if (numTokens == 4) {
                    double v1 = Double.valueOf(tokens[0]);
                    v2 = Double.valueOf(tokens[2]);
                    if (tokens[1].equals("-") || tokens[3].equals("-")) {
                        segments.add(new Object[]{new Double(v1), new Double(v2), null, null});
                        continue;
                    }
                    Color color1 = this.lookupColor(tokens[1]);
                    Color color2 = this.lookupColor(tokens[3]);
                    segments.add(new Object[]{new Double(v1), new Double(v2), color1, color2});
                    continue;
                }
                if (numTokens >= 10 && this.model_ == Model.CMYK) {
                    double v1 = Double.valueOf(tokens[0]);
                    v2 = Double.valueOf(tokens[5]);
                    segments.add(new Object[]{new Double(v1), new Double(v2), this.getCMYKColor(tokens[1], tokens[2], tokens[3], tokens[4]), this.getCMYKColor(tokens[6], tokens[7], tokens[8], tokens[9])});
                    continue;
                }
                if (numTokens >= 8 && this.model_ == Model.RGB) {
                    double v1 = Double.valueOf(tokens[0]);
                    v2 = Double.valueOf(tokens[4]);
                    segments.add(new Object[]{new Double(v1), new Double(v2), this.getRGBColor(tokens[1], tokens[2], tokens[3]), this.getRGBColor(tokens[5], tokens[6], tokens[7])});
                    continue;
                }
                if (numTokens >= 8 && this.model_ == Model.HSV) {
                    double v1 = Double.valueOf(tokens[0]);
                    v2 = Double.valueOf(tokens[4]);
                    segments.add(new Object[]{new Double(v1), new Double(v2), this.getHSVColor(tokens[1], tokens[2], tokens[3]), this.getHSVColor(tokens[5], tokens[6], tokens[7])});
                    continue;
                }
                throw new Exception("Bad token count: " + numTokens);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new ParseException("Error parsing CPT file", linesRead);
            }
        }
        bReader.close();
        if (nColor != null) {
            if (nColor instanceof HSVColor) {
                this.setNanColor(((HSVColor)((Object)nColor)).toRGBColor());
            } else if (nColor instanceof CMYKColor) {
                this.setNanColor(((CMYKColor)((Object)nColor)).toRGBColor());
            } else {
                this.setNanColor(nColor);
            }
        }
        for (int i2 = 0; i2 < segments.size(); ++i2) {
            Object[] data = (Object[])segments.elementAt(i2);
            if (data[2] != null && data[3] != null) continue;
            if (nColor == null) {
                throw new ParseException("Zone " + (i2 + 1) + " uses undefined NaN color", 0);
            }
            data[2] = nColor;
            data[3] = nColor;
        }
        Comparator segmentsCmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                Double d1 = (Double)((Object[])o1)[0];
                Double d2 = (Double)((Object[])o2)[0];
                return d1.compareTo(d2);
            }
        };
        Collections.sort(segments, segmentsCmp);
        double[][] rdata = new double[segments.size()][2];
        Object[][] cdata = new Object[segments.size()][2];
        for (int i3 = 0; i3 < segments.size(); ++i3) {
            Object[] data = (Object[])segments.elementAt(i3);
            rdata[i3][0] = (Double)data[0];
            rdata[i3][1] = (Double)data[1];
            cdata[i3][0] = data[2];
            cdata[i3][1] = data[3];
        }
        this.initiateArray(500);
        double rmin = rdata[0][0];
        double rmax = rdata[rdata.length - 1][1];
        this.setRangeMinimum(rmin);
        this.setRangeMaximum(rmax);
        double range = rmax - rmin;
        double delta = range / 500.0;
        int lastjj = 0;
        block5: for (i = 0; i < 500; ++i) {
            double val = rmin + delta * (0.5 + (double)i);
            for (int j = lastjj; j < segments.size(); ++j) {
                if (val < rdata[j][0] || val >= rdata[j][1]) continue;
                double pct = (val - rdata[j][0]) / (rdata[j][1] - rdata[j][0]);
                Object o1 = cdata[j][0];
                Object o2 = cdata[j][1];
                if (o1 instanceof HSVColor && o2 instanceof HSVColor) {
                    HSVColor hsv1 = (HSVColor)o1;
                    HSVColor hsv2 = (HSVColor)o2;
                    float h = hsv1.getH() + (float)pct * (hsv2.getH() - hsv1.getH());
                    float s = hsv1.getS() + (float)pct * (hsv2.getS() - hsv1.getS());
                    float v = hsv1.getV() + (float)pct * (hsv2.getV() - hsv1.getV());
                    this.setColorAt(i, Color.getHSBColor(h, s, v));
                } else {
                    Color c1 = o1 instanceof HSVColor ? ((HSVColor)o1).toRGBColor() : (o1 instanceof CMYKColor ? ((CMYKColor)o1).toRGBColor() : (Color)o1);
                    Color c2 = o2 instanceof HSVColor ? ((HSVColor)o2).toRGBColor() : (o2 instanceof CMYKColor ? ((CMYKColor)o2).toRGBColor() : (Color)o2);
                    int r1 = c1.getRed();
                    int r2 = c2.getRed();
                    int g1 = c1.getGreen();
                    int g2 = c2.getGreen();
                    int b1 = c1.getBlue();
                    int b2 = c2.getBlue();
                    int r = (int)((double)r1 + pct * (double)(r2 - r1));
                    int g = (int)((double)g1 + pct * (double)(g2 - g1));
                    int b = (int)((double)b1 + pct * (double)(b2 - b1));
                    this.setColorAt(i, new Color(r, g, b));
                }
                lastjj = j;
                continue block5;
            }
        }
        for (i = 0; i < 500; ++i) {
            if (this.getColorAt(i) != null) continue;
            this.setColorAt(i, Color.LIGHT_GRAY);
        }
    }

    private Color lookupColor(String name) throws ParseException {
        try {
            int shade = Integer.parseInt(name);
            if (this.model_ == Model.CMYK) {
                float f = 0.01f * (100.0f - (float)shade);
                return new Color(f, f, f);
            }
            return new Color(shade, shade, shade);
        }
        catch (Exception exception) {
            return ColorUtilities.parseColor(name);
        }
    }

    private Color getRGBColor(String r, String g, String b) {
        int r1 = Integer.parseInt(r);
        int g1 = Integer.parseInt(g);
        int b1 = Integer.parseInt(b);
        if (r1 < 0 || r1 > 255) {
            throw new IllegalArgumentException("R value out range 0 to 255");
        }
        if (g1 < 0 || g1 > 255) {
            throw new IllegalArgumentException("G value out range 0 to 255");
        }
        if (b1 < 0 || b1 > 255) {
            throw new IllegalArgumentException("B value out range 0 to 255");
        }
        return new Color(r1, g1, b1);
    }

    private CMYKColor getCMYKColor(String c, String m, String y, String k) {
        int c1 = Integer.parseInt(c);
        int m1 = Integer.parseInt(m);
        int y1 = Integer.parseInt(y);
        int k1 = Integer.parseInt(k);
        if (c1 < 0 || c1 > 100) {
            throw new IllegalArgumentException("C value outside valid range");
        }
        if (m1 < 0 || m1 > 100) {
            throw new IllegalArgumentException("M value outside valid range");
        }
        if (y1 < 0 || y1 > 100) {
            throw new IllegalArgumentException("Y value outside valid range");
        }
        if (k1 < 0 || k1 > 100) {
            throw new IllegalArgumentException("K value outside valid range");
        }
        if ((float)c1 > 1.0f || (float)m1 > 1.0f || (float)y1 > 1.0f || (float)k1 > 1.0f) {
            this.scale100_ = true;
        }
        return new CMYKColor(c1, m1, y1, k1);
    }

    private HSVColor getHSVColor(String h, String s, String v) {
        float h1 = (float)Integer.parseInt(h) * 0.0027777778f;
        float s1 = Float.parseFloat(s);
        float v1 = Float.parseFloat(v);
        if (h1 < 0.0f || h1 > 1.0f) {
            throw new IllegalArgumentException("H value outside valid range");
        }
        if (s1 < 0.0f || s1 > 100.0f) {
            throw new IllegalArgumentException("S value outside valid range");
        }
        if (v1 < 0.0f || v1 > 100.0f) {
            throw new IllegalArgumentException("V value outside valid range");
        }
        if (s1 > 1.0f || v1 > 1.0f) {
            this.scale100_ = true;
        }
        return new HSVColor(h1, s1, v1);
    }

    @Override
    public boolean saveAs(File f) throws IOException, FileNotFoundException {
        return false;
    }

    class HSVColor {
        float h_;
        float s_;
        float v_;

        HSVColor(float h, float s, float v) {
            this.h_ = h;
            this.s_ = s;
            this.v_ = v;
        }

        float getH() {
            return this.h_;
        }

        float getS() {
            return this.s_;
        }

        float getV() {
            return this.v_;
        }

        Color toRGBColor() {
            if (GmtColorTable.this.scale100_) {
                return Color.getHSBColor(this.h_, this.s_ * 0.1f, this.v_ * 0.1f);
            }
            return Color.getHSBColor(this.h_, this.s_, this.v_);
        }
    }

    class CMYKColor {
        float c_;
        float m_;
        float y_;
        float k_;

        CMYKColor(float c, float m, float y, float k) {
            this.c_ = c;
            this.m_ = m;
            this.y_ = y;
            this.k_ = k;
        }

        float getC() {
            return this.c_;
        }

        float getM() {
            return this.m_;
        }

        float getY() {
            return this.y_;
        }

        float getK() {
            return this.k_;
        }

        Color toRGBColor() {
            if (GmtColorTable.this.scale100_) {
                float r1 = 1.0f - Math.min(1.0f, (this.c_ + this.k_) * 0.01f);
                float g1 = 1.0f - Math.min(1.0f, (this.m_ + this.k_) * 0.01f);
                float b1 = 1.0f - Math.min(1.0f, (this.y_ + this.k_) * 0.01f);
                return new Color(r1, g1, b1);
            }
            float r1 = 1.0f - Math.min(1.0f, this.c_ + this.k_);
            float g1 = 1.0f - Math.min(1.0f, this.m_ + this.k_);
            float b1 = 1.0f - Math.min(1.0f, this.y_ + this.k_);
            return new Color(r1, g1, b1);
        }
    }

    private static enum Model {
        RGB,
        CMYK,
        HSV;

    }
}

