/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import gov.nasa.giss.graphics.colortable.AbstractBinaryColorTable;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class GissColorTable
extends AbstractBinaryColorTable {
    public GissColorTable() {
        this(256);
    }

    public GissColorTable(int count) {
        this.initiateArray(count, 256);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setMinOutlierColor(Color.BLACK);
        this.setMaxOutlierColor(Color.WHITE);
        this.setName("untitled");
        this.setType("GCT");
    }

    public GissColorTable(File f) throws IOException, FileNotFoundException {
        super(f, 768, 784);
    }

    public GissColorTable(URL url) throws IOException, FileNotFoundException {
        super(url, 768, 784);
    }

    public GissColorTable(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("GCT");
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        GissColorTable c = new GissColorTable(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    @Override
    public byte[] getBytes() {
        int i;
        byte[] b = new byte[778];
        int isize = this.getColorCount();
        for (i = 0; i < isize; ++i) {
            Color c = this.getColorAt(i);
            b[i * 3 + 0] = (byte)c.getRed();
            b[i * 3 + 1] = (byte)c.getGreen();
            b[i * 3 + 2] = (byte)c.getBlue();
        }
        for (i = isize; i < 256; ++i) {
            b[i * 3 + 0] = 0;
            b[i * 3 + 1] = 0;
            b[i * 3 + 2] = 0;
        }
        b[769] = (byte)isize;
        b[772] = (byte)this.getMinOutlierColor().getRed();
        b[773] = (byte)this.getMinOutlierColor().getGreen();
        b[774] = (byte)this.getMinOutlierColor().getBlue();
        b[775] = (byte)this.getMaxOutlierColor().getRed();
        b[776] = (byte)this.getMaxOutlierColor().getGreen();
        b[777] = (byte)this.getMaxOutlierColor().getBlue();
        return b;
    }

    @Override
    protected void fillColorTable(byte[] b) throws IOException {
        if (b.length < 768) {
            throw new IOException("Not a valid GCT color table");
        }
        int size = 256;
        if (b.length >= 772) {
            size = b[769] > 0 ? b[769] : 256 + b[769];
        }
        this.initiateArray(size, 256);
        for (int i = 0; i < size; ++i) {
            int ii = i * 3;
            if (i >= 256) {
                ii += 4;
            }
            this.setColorAt(i, new Color(0xFF & b[ii], 0xFF & b[ii + 1], 0xFF & b[ii + 2]));
        }
        if (b.length >= 778) {
            this.setMinOutlierColor(new Color(0xFF & b[772], 0xFF & b[773], 0xFF & b[774]));
            this.setMaxOutlierColor(new Color(0xFF & b[775], 0xFF & b[776], 0xFF & b[777]));
        }
    }
}

