/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.Vector;

public class GimpPalette
extends AbstractColorTable {
    public GimpPalette() {
        this(256);
    }

    public GimpPalette(int count) {
        this.initiateArray(count);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("GPL");
    }

    public GimpPalette(File f) throws FileNotFoundException, IllegalArgumentException, IOException, ParseException {
        if (f == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setURL(f.toURI().toURL());
        this.parseColorTable(new BufferedReader(new FileReader(f)));
    }

    public GimpPalette(URL url) throws IllegalArgumentException, IOException, ParseException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        this.setURL(url);
        this.parseColorTable(new BufferedReader(new InputStreamReader(new BufferedInputStream(url.openStream()))));
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        GimpPalette c = new GimpPalette(256);
        c.setName("Copy of " + this.getName());
        return c;
    }

    private void parseColorTable(BufferedReader bReader) throws IOException, ParseException {
        Vector<Color> v = new Vector<Color>(256);
        String oneLine = bReader.readLine();
        oneLine = oneLine.replaceFirst("^\\s+", "");
        if (!(oneLine = oneLine.replaceFirst("\\s+$", "")).toLowerCase().startsWith("gimp palette")) {
            throw new ParseException("Apparently not a GPL GIMP Palette", 1);
        }
        int linesRead = 1;
        while ((oneLine = bReader.readLine()) != null) {
            String[] tokens;
            int numTokens;
            ++linesRead;
            if (oneLine.startsWith("#") || oneLine.toLowerCase().startsWith("name") || (numTokens = (tokens = (oneLine = oneLine.replaceFirst("^\\s+", "")).split("\\s+")).length) < 3) continue;
            try {
                int r = Integer.valueOf(tokens[0]);
                int g = Integer.valueOf(tokens[1]);
                int b = Integer.valueOf(tokens[2]);
                v.add(new Color(r, g, b));
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new ParseException("Error parsing GPL file", linesRead);
            }
        }
        bReader.close();
        this.initiateArray(v.size());
        for (int i = 0; i < v.size(); ++i) {
            this.setColorAt(i, (Color)v.elementAt(i));
        }
    }

    @Override
    public boolean saveAs(File f) throws IOException, FileNotFoundException {
        return false;
    }
}

