/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;

public class GimpGradient
extends AbstractColorTable {
    private static final int FAUX_BINS = 500;
    private static final double HALF_PI = 1.5707963267948966;

    public GimpGradient() {
        this(100);
    }

    public GimpGradient(int count) {
        this.initiateArray(count);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("GGR");
    }

    public GimpGradient(File f) throws FileNotFoundException, IllegalArgumentException, IOException, ParseException {
        if (f == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setURL(f.toURI().toURL());
        this.parseColorTable(new BufferedReader(new FileReader(f)));
    }

    public GimpGradient(URL url) throws IllegalArgumentException, IOException, ParseException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        this.setURL(url);
        this.parseColorTable(new BufferedReader(new InputStreamReader(new BufferedInputStream(url.openStream()))));
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        GimpGradient c = new GimpGradient(256);
        c.setName("Copy of " + this.getName());
        return c;
    }

    private void parseColorTable(BufferedReader bReader) throws IOException, ParseException {
        int ibin;
        String oneLine = bReader.readLine();
        oneLine = oneLine.replaceFirst("^\\s+", "");
        if (!(oneLine = oneLine.replaceFirst("\\s+$", "")).equals("GIMP Gradient")) {
            throw new ParseException("Apparently not a GGR GIMP Gradient", 1);
        }
        oneLine = bReader.readLine();
        oneLine = bReader.readLine();
        oneLine = oneLine.replaceFirst("^\\s+", "");
        oneLine = oneLine.replaceFirst("\\s+$", "");
        int numSegs = Integer.valueOf(oneLine);
        double[][] rdata = new double[numSegs][3];
        Color[][] cdata = new Color[numSegs][2];
        int[] bdata = new int[numSegs];
        int[] mdata = new int[numSegs];
        for (int iseg = 0; iseg < numSegs; ++iseg) {
            oneLine = bReader.readLine();
            int comment = Math.min(oneLine.indexOf(";"), oneLine.indexOf("#"));
            if (comment > 0) {
                oneLine = oneLine.substring(0, comment - 1);
            }
            oneLine = oneLine.replaceFirst("^\\s+", "");
            String[] tokens = (oneLine = oneLine.replaceFirst("\\s+$", "")).split("\\s+");
            if (tokens.length < 13) {
                throw new ParseException("Bad token count " + tokens.length, iseg + 3);
            }
            try {
                rdata[iseg][0] = Double.valueOf(tokens[0]);
                rdata[iseg][1] = Double.valueOf(tokens[1]);
                rdata[iseg][2] = Double.valueOf(tokens[2]);
                cdata[iseg][0] = this.getRGBColor(tokens[3], tokens[4], tokens[5]);
                cdata[iseg][1] = this.getRGBColor(tokens[7], tokens[8], tokens[9]);
                bdata[iseg] = Integer.valueOf(tokens[11]);
                mdata[iseg] = Integer.valueOf(tokens[12]);
                continue;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new ParseException("Error parsing GGR file", iseg + 3);
            }
        }
        bReader.close();
        this.initiateArray(500);
        double rmin = rdata[0][0];
        double rmax = rdata[numSegs - 1][1];
        this.setRangeMinimum(rmin);
        this.setRangeMaximum(rmax);
        double range = rmax - rmin;
        double delta = range / 500.0;
        int lastSeg = 0;
        block3: for (ibin = 0; ibin < 500; ++ibin) {
            double val = rmin + delta * (0.5 + (double)ibin);
            for (int iseg = lastSeg; iseg < numSegs; ++iseg) {
                if (val < rdata[iseg][0] || val >= rdata[iseg][2]) continue;
                Color cleft = cdata[iseg][0];
                Color cright = cdata[iseg][1];
                double pct = val < rdata[iseg][1] ? 0.5 * (val - rdata[iseg][0]) / (rdata[iseg][1] - rdata[iseg][0]) : 0.5 + 0.5 * (val - rdata[iseg][1]) / (rdata[iseg][2] - rdata[iseg][1]);
                Color c = this.interpolate(cleft, cright, pct, mdata[iseg]);
                this.setColorAt(ibin, c);
                lastSeg = iseg;
                continue block3;
            }
        }
        for (ibin = 0; ibin < 500; ++ibin) {
            if (this.getColorAt(ibin) != null) continue;
            this.setColorAt(ibin, Color.LIGHT_GRAY);
        }
    }

    private Color interpolate(Color c1, Color c2, double pct, int how) {
        if (c1.equals(c2) && how == 0) {
            return c1;
        }
        double pctX = pct;
        switch (how) {
            case 2: {
                pctX = 0.5 * (1.0 + Math.cos(2.0 * (pct + 1.0) * 1.5707963267948966));
                break;
            }
            case 3: {
                pctX = Math.sin(pct * 1.5707963267948966);
                break;
            }
            case 4: {
                pctX = 1.0 - Math.cos(pct * 1.5707963267948966);
                break;
            }
            default: {
                pctX = pct;
            }
        }
        int r1 = c1.getRed();
        int r2 = c2.getRed();
        int g1 = c1.getGreen();
        int g2 = c2.getGreen();
        int b1 = c1.getBlue();
        int b2 = c2.getBlue();
        if (how == 0) {
            int r = (int)((double)r1 + pctX * (double)(r2 - r1));
            int g = (int)((double)g1 + pctX * (double)(g2 - g1));
            int b = (int)((double)b1 + pctX * (double)(b2 - b1));
            return new Color(r, g, b);
        }
        float[] hsv1 = Color.RGBtoHSB(r1, g1, b1, null);
        float[] hsv2 = Color.RGBtoHSB(r2, g2, b2, null);
        if (how == 2 && hsv2[0] < hsv1[0]) {
            hsv2[0] = hsv2[0] + 1.0f;
        }
        if (how == 1 && hsv2[0] > hsv1[0]) {
            hsv1[0] = hsv1[0] + 1.0f;
        }
        float h = hsv1[0] + (float)pctX * (hsv2[0] - hsv1[0]);
        float s = hsv1[1] + (float)pctX * (hsv2[1] - hsv1[1]);
        float v = hsv1[2] + (float)pctX * (hsv2[2] - hsv1[2]);
        return Color.getHSBColor(h, s, v);
    }

    private Color getRGBColor(String r, String g, String b) {
        float r1 = Float.parseFloat(r);
        float g1 = Float.parseFloat(g);
        float b1 = Float.parseFloat(b);
        if (r1 < 0.0f || r1 > 1.0f) {
            throw new IllegalArgumentException("R value outside valid range");
        }
        if (g1 < 0.0f || g1 > 1.0f) {
            throw new IllegalArgumentException("G value outside valid range");
        }
        if (b1 < 0.0f || b1 > 1.0f) {
            throw new IllegalArgumentException("B value out outside valid range");
        }
        return new Color(r1, g1, b1);
    }

    private HSVColor getHSVColor(String h, String s, String v) {
        float h1 = Float.parseFloat(h);
        float s1 = Float.parseFloat(s);
        float v1 = Float.parseFloat(v);
        if (h1 < 0.0f || h1 > 1.0f) {
            throw new IllegalArgumentException("H value outside valid range");
        }
        if (s1 < 0.0f || s1 > 1.0f) {
            throw new IllegalArgumentException("S value outside valid range");
        }
        if (v1 < 0.0f || v1 > 1.0f) {
            throw new IllegalArgumentException("V value outside valid range");
        }
        return new HSVColor(h1, s1, v1);
    }

    @Override
    public boolean saveAs(File f) throws IOException, FileNotFoundException {
        return false;
    }

    class HSVColor {
        float h_;
        float s_;
        float v_;

        HSVColor(float h, float s, float v) {
            this.h_ = h;
            this.s_ = s;
            this.v_ = v;
        }

        float getH() {
            return this.h_;
        }

        float getS() {
            return this.s_;
        }

        float getV() {
            return this.v_;
        }

        Color toRGBColor() {
            return Color.getHSBColor(this.h_, this.s_, this.v_);
        }
    }
}

