/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import gov.nasa.giss.graphics.colortable.ColorTableFactory;
import java.io.File;
import java.io.FilenameFilter;

public class ColorTableFilenameFilter
implements FilenameFilter {
    public static final String[] EXTENSIONS = ColorTableFactory.getValidExtensions();

    @Override
    public boolean accept(File dir, String name) {
        if (ColorTableFilenameFilter.isColorTableName(name)) {
            return true;
        }
        return new File(dir, name).isDirectory();
    }

    public static boolean isColorTableName(File f) {
        if (f == null) {
            throw new IllegalArgumentException("File is null.");
        }
        return ColorTableFilenameFilter.isColorTableName(f.getName());
    }

    public static boolean isColorTableName(String fname) {
        if (fname == null) {
            throw new IllegalArgumentException("File name is null.");
        }
        String lcname = fname.toLowerCase();
        for (int i = 0; i < EXTENSIONS.length; ++i) {
            if (!lcname.endsWith(EXTENSIONS[i])) continue;
            return true;
        }
        return false;
    }
}

