/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.graphics.colortable.AdobeColorTable;
import gov.nasa.giss.graphics.colortable.ClarisWorksColorTable;
import gov.nasa.giss.graphics.colortable.GimpGradient;
import gov.nasa.giss.graphics.colortable.GimpPalette;
import gov.nasa.giss.graphics.colortable.GissColorTable;
import gov.nasa.giss.graphics.colortable.GmtColorTable;
import gov.nasa.giss.graphics.colortable.Pal1ColorTable;
import gov.nasa.giss.graphics.colortable.Pal2ColorTable;
import gov.nasa.giss.graphics.colortable.PalColorTable;
import gov.nasa.giss.graphics.colortable.SvgGradient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.ParseException;

public class ColorTableFactory {
    private static final Object[][] CLASSES_INFO = new Object[][]{{"pal", PalColorTable.class}, {"pa1", Pal1ColorTable.class}, {"pal1", Pal1ColorTable.class}, {"pa2", Pal2ColorTable.class}, {"pal2", Pal2ColorTable.class}, {"cpt", GmtColorTable.class}, {"act", AdobeColorTable.class}, {"gct", GissColorTable.class}, {"cwc", ClarisWorksColorTable.class}, {"gpl", GimpPalette.class}, {"ggr", GimpGradient.class}, {"svg", SvgGradient.class}};

    private ColorTableFactory() {
    }

    public static boolean isColorTableName(File f) {
        return ColorTableFactory.isColorTableName(f.getName());
    }

    public static boolean isColorTableName(String fname) {
        String lcname = fname.toLowerCase();
        for (Object[] oinfo : CLASSES_INFO) {
            if (!lcname.endsWith("." + oinfo[0])) continue;
            return true;
        }
        return false;
    }

    public static AbstractColorTable create(String type) {
        Class ctClass = ColorTableFactory.classForName(type);
        if (ctClass == null) {
            throw new IllegalArgumentException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{};
            Object[] args = new Object[]{};
            Constructor c = ctClass.getConstructor(types);
            return (AbstractColorTable)c.newInstance(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Construction error: " + exc.toString());
        }
    }

    public static AbstractColorTable open(File f) throws IOException, FileNotFoundException, ParseException {
        return ColorTableFactory.initFromFile(f);
    }

    public static AbstractColorTable open(URL url) throws IOException, FileNotFoundException, ParseException {
        if (url == null) {
            throw new FileNotFoundException("Cannot open null file");
        }
        Class ctClass = ColorTableFactory.classForName(url.getFile());
        if (ctClass == null) {
            throw new FileNotFoundException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{URL.class};
            Object[] args = new Object[]{url};
            Constructor c = ctClass.getConstructor(types);
            return (AbstractColorTable)c.newInstance(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Construction error: " + exc.toString());
        }
    }

    public static AbstractColorTable open(byte[] bytes, String name) throws IOException {
        Class ctClass = ColorTableFactory.classForName(name);
        if (ctClass == null) {
            throw new FileNotFoundException("Filename has unrecognized extension");
        }
        try {
            Class[] types = new Class[]{byte[].class};
            Object[] args = new Object[]{bytes};
            Constructor c = ctClass.getConstructor(types);
            return (AbstractColorTable)c.newInstance(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Construction error: " + exc.toString());
        }
    }

    private static AbstractColorTable initFromFile(File file) throws FileNotFoundException, IllegalArgumentException, IOException, ParseException {
        if (file == null) {
            throw new FileNotFoundException("Cannot open nullfile");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        Class ctClass = ColorTableFactory.classForName(file.getName());
        if (ctClass == null) {
            throw new FileNotFoundException("Filename has unrecognized extension.");
        }
        try {
            Class[] types = new Class[]{File.class};
            Object[] args = new Object[]{file};
            Constructor c = ctClass.getConstructor(types);
            return (AbstractColorTable)c.newInstance(args);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not extract color table information.");
        }
    }

    private static Class classForName(String fname) {
        String lcname = fname.toLowerCase();
        for (Object[] oinfo : CLASSES_INFO) {
            String ext = (String)oinfo[0];
            if (!lcname.equals(ext) && !lcname.endsWith("." + ext)) continue;
            return (Class)oinfo[1];
        }
        return null;
    }

    public static String[] getValidExtensions() {
        String[] array = new String[CLASSES_INFO.length];
        for (int i = 0; i < CLASSES_INFO.length; ++i) {
            array[i] = (String)CLASSES_INFO[i][0];
        }
        return array;
    }
}

