/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import gov.nasa.giss.graphics.colortable.AbstractBinaryColorTable;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class ClarisWorksColorTable
extends AbstractBinaryColorTable {
    public ClarisWorksColorTable() {
        this.initiateArray(256);
        for (int i = 0; i < 256; ++i) {
            float bright = (float)i / 255.0f;
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("CWC");
    }

    public ClarisWorksColorTable(File f) throws IOException, FileNotFoundException {
        super(f, 2070, 2070);
    }

    public ClarisWorksColorTable(URL url) throws IOException, FileNotFoundException {
        super(url, 2070, 2070);
    }

    public ClarisWorksColorTable(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("CWC");
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        ClarisWorksColorTable c = new ClarisWorksColorTable(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    @Override
    public byte[] getBytes() {
        byte[] b = new byte[2070];
        b[0] = 66;
        b[1] = 79;
        b[2] = 66;
        b[3] = 79;
        b[4] = 6;
        b[5] = 7;
        b[6] = 100;
        b[7] = 67;
        b[8] = 76;
        b[9] = 85;
        b[12] = 8;
        b[13] = 8;
        b[21] = -1;
        for (int i = 0; i < 256; ++i) {
            Color c = this.getColorAt(i);
            int offset = 22 + i * 8;
            b[offset] = 0;
            b[offset + 1] = (byte)i;
            b[offset + 2] = (byte)c.getRed();
            b[offset + 3] = (byte)c.getRed();
            b[offset + 4] = (byte)c.getGreen();
            b[offset + 5] = (byte)c.getGreen();
            b[offset + 6] = (byte)c.getBlue();
            b[offset + 7] = (byte)c.getBlue();
        }
        return b;
    }

    @Override
    protected void fillColorTable(byte[] b) throws IOException {
        if (b.length < 2070) {
            throw new IOException("Not a valid CWC color table");
        }
        this.initiateArray(256);
        for (int i = 0; i < 256; ++i) {
            int offset = 22 + i * 8;
            this.setColorAt(i, new Color(0xFF & b[offset + 2], 0xFF & b[offset + 4], 0xFF & b[offset + 6]));
        }
    }
}

