/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import gov.nasa.giss.graphics.colortable.AbstractBinaryColorTable;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class AdobeColorTable
extends AbstractBinaryColorTable {
    public AdobeColorTable() {
        this(256);
    }

    public AdobeColorTable(int count) {
        this.initiateArray(count, 256);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("ACT");
    }

    public AdobeColorTable(File f) throws IOException, FileNotFoundException {
        super(f, 768, 772);
    }

    public AdobeColorTable(URL url) throws IOException, FileNotFoundException {
        super(url, 768, 772);
    }

    public AdobeColorTable(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("ACT");
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        AdobeColorTable c = new AdobeColorTable(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    @Override
    public byte[] getBytes() {
        int i;
        byte[] b = new byte[772];
        int isize = this.getColorCount();
        for (i = 0; i < isize; ++i) {
            Color c = this.getColorAt(i);
            b[i * 3 + 0] = (byte)c.getRed();
            b[i * 3 + 1] = (byte)c.getGreen();
            b[i * 3 + 2] = (byte)c.getBlue();
        }
        for (i = isize; i < 256; ++i) {
            b[i * 3 + 0] = 0;
            b[i * 3 + 1] = 0;
            b[i * 3 + 2] = 0;
        }
        b[769] = (byte)isize;
        return b;
    }

    @Override
    protected void fillColorTable(byte[] b) throws IOException {
        if (b.length < 768) {
            throw new IOException("Not a valid ACT color table");
        }
        int size = 256;
        if (b.length == 772) {
            size = b[769] > 0 ? b[769] : 256 + b[769];
        }
        this.initiateArray(size, 256);
        for (int i = 0; i < size; ++i) {
            this.setColorAt(i, new Color(0xFF & b[i * 3], 0xFF & b[i * 3 + 1], 0xFF & b[i * 3 + 2]));
        }
    }
}

