/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public abstract class AbstractColorTable {
    private static final String PATH_SEP = System.getProperty("file.separator");
    private URL url_;
    private String fname_;
    private String froot_;
    private String fext_;
    private int size_;
    private int maxBin_;
    private boolean fixedSize_ = true;
    private int maxSize_;
    private Color[] colors_;
    private Color minOutlierColor_;
    private Color maxOutlierColor_;
    private Color nanColor_;
    private double rangeMin_ = Double.NaN;
    private double rangeMax_ = Double.NaN;

    protected AbstractColorTable() {
    }

    public abstract boolean saveAs(File var1) throws IOException, FileNotFoundException;

    public abstract AbstractColorTable copy() throws IOException;

    protected void initiateArray(int size) {
        this.size_ = size;
        this.colors_ = new Color[size];
        this.maxBin_ = size - 1;
    }

    protected void initiateArray(int size, int maxSize) {
        this.initiateArray(size);
        this.fixedSize_ = false;
        this.maxSize_ = maxSize;
    }

    public URL getURL() {
        return this.url_;
    }

    public void setURL(URL url) {
        if (this.url_ == null) {
            this.url_ = url;
            this.setName(url.getFile());
        }
    }

    public String getName() {
        return this.fname_;
    }

    public void setName(String s) {
        this.fname_ = s;
        int lastSeparator = s.lastIndexOf(PATH_SEP);
        int lastSlash = s.lastIndexOf("/");
        if (lastSlash > lastSeparator) {
            lastSeparator = lastSlash;
        }
        this.fname_ = s.substring(lastSeparator + 1);
        int lastDot = this.fname_.lastIndexOf(".");
        if (lastDot > -1) {
            this.froot_ = this.fname_.substring(0, lastDot);
            this.fext_ = this.fname_.substring(lastDot + 1).toLowerCase();
        } else {
            this.froot_ = this.fname_;
            this.fext_ = null;
        }
    }

    public String getType() {
        return this.fext_;
    }

    public void setType(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        this.fext_ = s.toLowerCase();
    }

    public String toString() {
        return this.getName();
    }

    public String getDescription() {
        if (this.fext_ != null) {
            return this.getName() + " " + this.fext_.toUpperCase();
        }
        return this.getName();
    }

    public int getColorCount() {
        return this.size_;
    }

    public boolean hasOutlierColors() {
        return this.minOutlierColor_ != null && this.maxOutlierColor_ != null;
    }

    public Color getColorAt(int bin) {
        if (bin < 0 || bin >= this.size_) {
            return Color.BLACK;
        }
        return this.colors_[bin];
    }

    public Color getColorAt(int bin, boolean flipped) {
        if (bin < 0 || bin >= this.size_) {
            return Color.BLACK;
        }
        if (flipped) {
            return this.colors_[this.maxBin_ - bin];
        }
        return this.colors_[bin];
    }

    public void setColorAt(int bin, Color c) {
        if (bin < 0 || bin >= this.size_) {
            throw new IllegalArgumentException("Bad color table entry number");
        }
        this.colors_[bin] = c;
    }

    public int getRGBAt(int bin) {
        if (bin < 0 || bin >= this.size_) {
            return 0;
        }
        return this.colors_[bin].getRGB();
    }

    public int getRGBAt(int bin, boolean flipped) {
        if (bin < 0 || bin >= this.size_) {
            return 0;
        }
        if (flipped) {
            return this.colors_[this.maxBin_ - bin].getRGB();
        }
        return this.colors_[bin].getRGB();
    }

    public void insertColorAt(int bin, Color c) {
        int i;
        if (this.fixedSize_) {
            throw new IllegalArgumentException("ColorTable format does not allow for insertions.");
        }
        if (bin < 0 || bin > this.size_) {
            throw new IllegalArgumentException("Color bin index is out of range.");
        }
        if (this.maxSize_ > -1 && this.size_ >= this.maxSize_) {
            throw new IllegalArgumentException("Can not add any more colors.");
        }
        ++this.size_;
        Color[] newArray = new Color[this.size_];
        for (i = 0; i < bin; ++i) {
            newArray[i] = this.colors_[i];
        }
        newArray[bin] = c;
        for (i = bin + 1; i < this.size_; ++i) {
            newArray[i] = this.colors_[i - 1];
        }
        this.maxBin_ = this.size_ - 1;
        this.colors_ = newArray;
    }

    public Color deleteColorAt(int bin) {
        int i;
        if (this.fixedSize_) {
            throw new IllegalArgumentException("ColorTable format does not allow for deletions.");
        }
        if (bin < 0 || bin >= this.size_) {
            throw new IllegalArgumentException("Color bin index is out of range.");
        }
        if (this.size_ < 2) {
            throw new IllegalArgumentException("Can not delete last remaining color.");
        }
        --this.size_;
        Color[] newArray = new Color[this.size_];
        Color victim = this.colors_[bin];
        for (i = 0; i < bin; ++i) {
            newArray[i] = this.colors_[i];
        }
        for (i = bin; i < this.size_; ++i) {
            newArray[i] = this.colors_[i + 1];
        }
        this.maxBin_ = this.size_ - 1;
        this.colors_ = newArray;
        return victim;
    }

    public Color getMinOutlierColor() {
        return this.getMinOutlierColor(false);
    }

    public Color getMinOutlierColor(boolean flipped) {
        if (flipped) {
            if (this.maxOutlierColor_ != null) {
                return this.maxOutlierColor_;
            }
            return this.colors_[this.maxBin_];
        }
        if (this.minOutlierColor_ != null) {
            return this.minOutlierColor_;
        }
        return this.colors_[0];
    }

    public void setMinOutlierColor(Color c) {
        this.minOutlierColor_ = c;
    }

    public int getMinOutlierRGB() {
        return this.getMinOutlierRGB(false);
    }

    public int getMinOutlierRGB(boolean flipped) {
        if (flipped) {
            if (this.maxOutlierColor_ != null) {
                return this.maxOutlierColor_.getRGB();
            }
            return this.colors_[this.maxBin_].getRGB();
        }
        if (this.minOutlierColor_ != null) {
            return this.minOutlierColor_.getRGB();
        }
        return this.colors_[0].getRGB();
    }

    public Color getMaxOutlierColor() {
        return this.getMaxOutlierColor(false);
    }

    public Color getMaxOutlierColor(boolean flipped) {
        if (flipped) {
            if (this.minOutlierColor_ != null) {
                return this.minOutlierColor_;
            }
            return this.colors_[0];
        }
        if (this.maxOutlierColor_ != null) {
            return this.maxOutlierColor_;
        }
        return this.colors_[this.maxBin_];
    }

    public void setMaxOutlierColor(Color c) {
        this.maxOutlierColor_ = c;
    }

    public int getMaxOutlierRGB() {
        return this.getMaxOutlierRGB(false);
    }

    public int getMaxOutlierRGB(boolean flipped) {
        if (flipped) {
            if (this.minOutlierColor_ != null) {
                return this.minOutlierColor_.getRGB();
            }
            return this.colors_[0].getRGB();
        }
        if (this.maxOutlierColor_ != null) {
            return this.maxOutlierColor_.getRGB();
        }
        return this.colors_[this.maxBin_].getRGB();
    }

    public boolean hasNanColor() {
        return this.nanColor_ != null;
    }

    public Color getNanColor() {
        return this.nanColor_;
    }

    public void setNanColor(Color c) {
        this.nanColor_ = c;
    }

    public int getNanRGB() {
        if (this.nanColor_ != null) {
            return this.nanColor_.getRGB();
        }
        return 0;
    }

    public boolean hasRangeLimits() {
        return !Double.isNaN(this.rangeMin_) && !Double.isNaN(this.rangeMax_);
    }

    public double getRangeMinimum() {
        return this.rangeMin_;
    }

    public void setRangeMinimum(double d) {
        this.rangeMin_ = d;
    }

    public double getRangeMaximum() {
        return this.rangeMax_;
    }

    public void setRangeMaximum(double d) {
        this.rangeMax_ = d;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AbstractColorTable)) {
            return false;
        }
        return ((AbstractColorTable)o).getURL().equals(this.getURL());
    }
}

