/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.colortable;

import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class AbstractBinaryColorTable
extends AbstractColorTable {
    protected AbstractBinaryColorTable() {
    }

    protected AbstractBinaryColorTable(File f, int min, int max) throws FileNotFoundException, IllegalArgumentException, IOException {
        if (f == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setURL(f.toURI().toURL());
        this.fillColorTable(this.readBytes(new FileInputStream(f), min, max));
    }

    protected AbstractBinaryColorTable(URL url, int min, int max) throws IllegalArgumentException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        this.setURL(url);
        this.fillColorTable(this.readBytes(new DataInputStream(new BufferedInputStream(url.openStream())), min, max));
    }

    public AbstractBinaryColorTable(byte[] b) throws IOException, FileNotFoundException {
        this.fillColorTable(b);
    }

    @Override
    public boolean saveAs(File f) throws IOException, FileNotFoundException {
        FileOutputStream ostream = new FileOutputStream(f);
        ostream.write(this.getBytes());
        ostream.close();
        return true;
    }

    protected abstract byte[] getBytes();

    protected abstract void fillColorTable(byte[] var1) throws IOException;

    private byte[] readBytes(InputStream is, int min, int max) throws IOException, IllegalArgumentException {
        if (min <= 0 || max <= 0) {
            throw new IllegalArgumentException("Bytecount must be positive");
        }
        if (min > max) {
            throw new IllegalArgumentException("Max bytecount must be >= min");
        }
        byte[] b = new byte[max];
        int bytesRead = is.read(b);
        is.close();
        if (bytesRead < min) {
            throw new IOException("Invalid color table.  Could not read at least " + min + " bytes.");
        }
        return b;
    }
}

