/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public final class GraphicUtilities {
    private GraphicUtilities() {
    }

    public static void antialias(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
    }

    public static void drawLine(Graphics2D g2d, float x1, float y1, float x2, float y2) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        g2d.draw(path);
    }

    public static void drawLine(Graphics2D g2d, double x1, double y1, double x2, double y2) {
        GeneralPath path = new GeneralPath();
        path.moveTo((float)x1, (float)y1);
        path.lineTo((float)x2, (float)y2);
        g2d.draw(path);
    }

    public static void drawRect(Graphics2D g2d, float x, float y, float w, float h) {
        Rectangle2D.Float r = new Rectangle2D.Float(x, y, w, h);
        g2d.draw(r);
    }

    public static void fillRect(Graphics2D g2d, float x, float y, float w, float h) {
        Rectangle2D.Float r = new Rectangle2D.Float(x, y, w, h);
        g2d.fill(r);
    }

    public static void fillDrawnRect(Graphics2D g2d, float x, float y, float w, float h) {
        Rectangle2D.Float r = new Rectangle2D.Float(x, y, w, h);
        g2d.fill(r);
        g2d.draw(r);
    }

    public static void drawString(Graphics2D g2d, String s, int x, int y) {
        GraphicUtilities.drawString(g2d, s, (float)x, (float)y);
    }

    public static void drawString(Graphics2D g2d, String s, float x, float y) {
        GlyphVector gv = g2d.getFont().createGlyphVector(g2d.getFontRenderContext(), s.toCharArray());
        g2d.drawGlyphVector(gv, x, y);
    }
}

