/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import java.awt.Color;
import java.text.ParseException;

public final class ColorUtilities {
    private ColorUtilities() {
    }

    public static String colorToString(Color c) {
        StringBuilder result = new StringBuilder("");
        if (c.getAlpha() < 255) {
            result.append("rgba(");
        } else {
            result.append("rgb(");
        }
        result.append(c.getRed()).append(",").append(c.getGreen()).append(",").append(c.getBlue());
        if (c.getAlpha() < 255) {
            result.append(",").append(c.getAlpha());
        }
        result.append(")");
        return result.toString();
    }

    public static Color parseColor(String s) throws ParseException {
        if (s == null) {
            throw new IllegalArgumentException("Color string is null");
        }
        if (s.startsWith("java.awt.Color[")) {
            try {
                s = s.replaceFirst(".*\\[", "");
                s = s.replaceFirst("\\].*", "");
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            try {
                String[] rgbx = s.split(",");
                if (rgbx.length < 3) {
                    return null;
                }
                int[] rgb = new int[3];
                for (int i = 0; i < 3; ++i) {
                    rgbx[i] = rgbx[i].replaceAll("\\D", "");
                    rgb[i] = Integer.parseInt(rgbx[i]);
                    rgb[i] = Math.max(rgb[i], 0);
                    rgb[i] = Math.min(rgb[i], 255);
                }
                return new Color(rgb[0], rgb[1], rgb[2]);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        } else if (s.startsWith("rgb(") && s.indexOf("%") > -1) {
            try {
                s = s.replaceFirst(".*\\(", "");
                s = s.replaceFirst("\\).*", "");
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            try {
                String[] rgbx = s.split(",");
                if (rgbx.length < 3) {
                    return null;
                }
                float[] rgb = new float[3];
                for (int i = 0; i < 3; ++i) {
                    rgbx[i] = rgbx[i].replaceAll("\\%", "");
                    rgbx[i] = rgbx[i].replaceAll("\\D", "");
                    rgb[i] = Float.parseFloat(rgbx[i]);
                    rgb[i] = Math.max(rgb[i], 0.0f);
                    rgb[i] = Math.min(rgb[i], 255.0f);
                }
                return new Color(rgb[0], rgb[1], rgb[2]);
            }
            catch (Exception ignore) {}
        } else if (s.startsWith("rgb(") || s.startsWith("rgba(")) {
            try {
                s = s.replaceFirst(".*\\(", "");
                s = s.replaceFirst("\\).*", "");
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            try {
                String[] rgbx = s.split(",");
                if (rgbx.length < 3) {
                    return null;
                }
                int[] rgb = new int[rgbx.length];
                for (int i = 0; i < rgbx.length; ++i) {
                    rgbx[i] = rgbx[i].replaceAll("\\D", "");
                    rgb[i] = Integer.parseInt(rgbx[i]);
                    rgb[i] = Math.max(rgb[i], 0);
                    rgb[i] = Math.min(rgb[i], 255);
                }
                if (rgb.length == 4) {
                    return new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
                }
                return new Color(rgb[0], rgb[1], rgb[2]);
            }
            catch (Exception ignore) {}
        } else if (s.startsWith("#")) {
            if ((s = s.substring(1)).length() == 3) {
                char c1 = s.charAt(0);
                char c2 = s.charAt(1);
                char c3 = s.charAt(2);
                return Color.decode("0x" + c1 + c1 + c2 + c2 + c3 + c3);
            }
            if (s.length() == 6) {
                return Color.decode("0x" + s);
            }
        } else {
            if (s.equalsIgnoreCase("black")) {
                return Color.BLACK;
            }
            if (s.equalsIgnoreCase("silver")) {
                return Color.LIGHT_GRAY;
            }
            if (s.equalsIgnoreCase("gray")) {
                return Color.GRAY;
            }
            if (s.equalsIgnoreCase("white")) {
                return Color.WHITE;
            }
            if (s.equalsIgnoreCase("maroon")) {
                return Color.decode("0x800000");
            }
            if (s.equalsIgnoreCase("red")) {
                return Color.RED;
            }
            if (s.equalsIgnoreCase("purple")) {
                return Color.decode("0x800080");
            }
            if (s.equalsIgnoreCase("fuchsia")) {
                return Color.MAGENTA;
            }
            if (s.equalsIgnoreCase("green")) {
                return Color.decode("0x008000");
            }
            if (s.equalsIgnoreCase("lime")) {
                return Color.GREEN;
            }
            if (s.equalsIgnoreCase("olive")) {
                return Color.decode("0x808000");
            }
            if (s.equalsIgnoreCase("yellow")) {
                return Color.YELLOW;
            }
            if (s.equalsIgnoreCase("navy")) {
                return Color.decode("0x000080");
            }
            if (s.equalsIgnoreCase("blue")) {
                return Color.BLUE;
            }
            if (s.equalsIgnoreCase("teal")) {
                return Color.decode("0x008080");
            }
            if (s.equalsIgnoreCase("aqua")) {
                return Color.decode("0x00ffff");
            }
            if (s.equalsIgnoreCase("cyan")) {
                return Color.CYAN;
            }
            if (s.equalsIgnoreCase("darkgray") || s.equalsIgnoreCase("dark_gray")) {
                return Color.DARK_GRAY;
            }
            if (s.equalsIgnoreCase("lightgray") || s.equalsIgnoreCase("light_gray")) {
                return Color.LIGHT_GRAY;
            }
            if (s.equalsIgnoreCase("magenta")) {
                return Color.MAGENTA;
            }
            if (s.equalsIgnoreCase("orange")) {
                return Color.ORANGE;
            }
            if (s.equalsIgnoreCase("pink")) {
                return Color.PINK;
            }
        }
        throw new ParseException("Unrecognized color string", 0);
    }
}

