/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;

public class Bezier {
    private boolean closed_;
    private Point2D.Double[] anchors_;
    private Point2D.Double[][] controls_;

    public Bezier(boolean b, Point2D.Double[] a) {
        this.closed_ = b;
        this.setAnchors(a);
    }

    public Bezier(boolean b, ArrayList<Point2D.Double> al) {
        this.closed_ = b;
        this.setAnchors(al);
    }

    public Bezier(boolean b, Vector<Point2D.Double> v) {
        this.closed_ = b;
        this.setAnchors(v);
    }

    public boolean isClosed() {
        return this.closed_;
    }

    public void setClosed(boolean b) {
        this.closed_ = b;
        this.controls_ = null;
    }

    public Point2D.Double[] getAnchors() {
        return this.anchors_;
    }

    public void setAnchors(Point2D.Double[] a) {
        this.anchors_ = a;
        this.controls_ = null;
    }

    public void setAnchors(ArrayList<Point2D.Double> al) {
        this.setAnchors(al.toArray(new Point2D.Double[0]));
    }

    public void setAnchors(Vector<Point2D.Double> v) {
        this.setAnchors(v.toArray(new Point2D.Double[0]));
    }

    public Point2D.Double[][] getControls() {
        if (this.controls_ == null) {
            this.interpolateControls();
        }
        return this.controls_;
    }

    public GeneralPath getPath() {
        if (this.controls_ == null) {
            this.interpolateControls();
        }
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)this.anchors_[0].x, (float)this.anchors_[0].y);
        int numIntervals = this.closed_ ? this.anchors_.length : this.anchors_.length - 1;
        for (int i = 0; i < numIntervals; ++i) {
            if (this.closed_ && i == numIntervals - 1) {
                gp.curveTo((float)this.controls_[i][0].x, (float)this.controls_[i][0].y, (float)this.controls_[i][1].x, (float)this.controls_[i][1].y, (float)this.anchors_[0].x, (float)this.anchors_[0].y);
                continue;
            }
            gp.curveTo((float)this.controls_[i][0].x, (float)this.controls_[i][0].y, (float)this.controls_[i][1].x, (float)this.controls_[i][1].y, (float)this.anchors_[i + 1].x, (float)this.anchors_[i + 1].y);
        }
        return gp;
    }

    public void paint(Graphics2D g2d) {
        g2d.draw(this.getPath());
    }

    private void interpolateControls() {
        int numIntervals = this.closed_ ? this.anchors_.length : this.anchors_.length - 1;
        int istart = this.closed_ ? 0 : 1;
        int lastAnchor = this.anchors_.length - 1;
        int lastInterval = numIntervals - 1;
        double smoothness = 0.9;
        this.controls_ = new Point2D.Double[numIntervals][2];
        for (int i = istart; i < numIntervals; ++i) {
            int im1 = i - 1 < 0 ? lastAnchor : i - 1;
            int ip1 = i + 1 > lastAnchor ? 0 : i + 1;
            double xc1 = 0.5 * (this.anchors_[im1].x + this.anchors_[i].x);
            double yc1 = 0.5 * (this.anchors_[im1].y + this.anchors_[i].y);
            double xc2 = 0.5 * (this.anchors_[i].x + this.anchors_[ip1].x);
            double yc2 = 0.5 * (this.anchors_[i].y + this.anchors_[ip1].y);
            double len1 = this.anchors_[i].distance(this.anchors_[im1]);
            double len2 = this.anchors_[i].distance(this.anchors_[ip1]);
            double k1 = len1 / (len1 + len2);
            double xm1 = xc1 + (xc2 - xc1) * k1;
            double ym1 = yc1 + (yc2 - yc1) * k1;
            this.controls_[im1][1] = new Point2D.Double(this.anchors_[i].x + (xc1 - xm1) * 0.9, this.anchors_[i].y + (yc1 - ym1) * 0.9);
            this.controls_[i][0] = new Point2D.Double(this.anchors_[i].x + (xc2 - xm1) * 0.9, this.anchors_[i].y + (yc2 - ym1) * 0.9);
        }
        if (!this.closed_) {
            this.controls_[0][0] = new Point2D.Double(this.anchors_[0].x, this.anchors_[0].y);
            this.controls_[lastInterval][1] = new Point2D.Double(this.anchors_[lastAnchor].x, this.anchors_[lastAnchor].y);
        }
    }
}

