/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.geom;

public class Point3DCartesian {
    private double x_;
    private double y_;
    private double z_;
    private double r_;
    private double theta_;
    private double phi_;
    private double rho_;
    private boolean needsUpdate_ = true;

    public Point3DCartesian() {
        this(0.0, 0.0, 0.0);
    }

    public Point3DCartesian(double x, double y, double z) {
        this.set(x, y, z);
    }

    public void set(double x, double y, double z) {
        this.x_ = x;
        this.y_ = y;
        this.z_ = z;
        this.needsUpdate_ = true;
    }

    public void translate(double dx, double dy, double dz) {
        this.set(this.x_ + dx, this.y_ + dy, this.z_ + dz);
    }

    public void rotateAxis(Axis axis, double angle, AngularUnits units) {
        if (axis == null) {
            throw new IllegalArgumentException("Null rotation axis");
        }
        if (units == null) {
            throw new IllegalArgumentException("Null rotation units");
        }
        double angleRad = units == AngularUnits.DEGREES ? angle * (Math.PI / 180) : angle;
        double cosA = Math.cos(angleRad);
        double sinA = Math.sin(angleRad);
        double xPrime = this.x_;
        double yPrime = this.y_;
        double zPrime = this.z_;
        switch (axis) {
            case X: {
                xPrime = this.x_;
                yPrime = this.y_ * cosA + this.z_ * sinA;
                zPrime = -this.y_ * sinA + this.z_ * cosA;
                break;
            }
            case Y: {
                xPrime = this.x_ * cosA - this.z_ * sinA;
                yPrime = this.y_;
                zPrime = this.x_ * sinA + this.z_ * cosA;
                break;
            }
            case Z: {
                xPrime = this.x_ * cosA + this.y_ * sinA;
                yPrime = -this.x_ * sinA + this.y_ * cosA;
                zPrime = this.z_;
            }
        }
        this.set(xPrime, yPrime, zPrime);
    }

    public double getX() {
        return this.x_;
    }

    public double getY() {
        return this.y_;
    }

    public double getZ() {
        return this.z_;
    }

    public double getR() {
        if (this.needsUpdate_) {
            this.update();
        }
        return this.r_;
    }

    public double getTheta() {
        if (this.needsUpdate_) {
            this.update();
        }
        return this.theta_;
    }

    public double getPhi() {
        if (this.needsUpdate_) {
            this.update();
        }
        return this.phi_;
    }

    private void update() {
        double xx = this.x_ * this.x_;
        double yy = this.y_ * this.y_;
        double zz = this.z_ * this.z_;
        this.rho_ = Math.sqrt(xx + yy);
        this.r_ = Math.sqrt(xx + yy + zz);
        this.theta_ = Math.atan2(this.y_, this.x_) * 57.29577951308232;
        this.phi_ = this.r_ == 0.0 ? 0.0 : Math.acos(this.z_ / this.r_) * 57.29577951308232;
        this.needsUpdate_ = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AngularUnits {
        DEGREES,
        RADIANS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axis {
        X,
        Y,
        Z;

    }
}

