/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data;

import gov.nasa.giss.data.ContourLevel;
import gov.nasa.giss.data.ContourLevels;
import gov.nasa.giss.data.ContourLine;
import gov.nasa.giss.data.DataGrid2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Contours2D {
    private static Logger logger_ = LoggerFactory.getLogger(Contours2D.class);
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;
    private static final int STEP = 2;
    private static final double DSTEP = 2.0;
    private DataGrid2D data_;
    private int numRows_;
    private int numCols_;
    private double[] values_;
    private ContourLevels levels_;

    public Contours2D(DataGrid2D data) {
        this.data_ = data;
    }

    public double[] getLevelValues() {
        return this.values_;
    }

    public void setLevelValues(double[] values) {
        this.values_ = values;
    }

    public ContourLevels getLevels() {
        this.scan();
        return this.levels_;
    }

    private void scan() {
        this.levels_ = new ContourLevels(0);
        if (this.data_ == null) {
            throw new NullPointerException("Data object has not been set.");
        }
        if (this.values_ == null) {
            throw new NullPointerException("Level values have not been set.");
        }
        int numLevels = this.values_.length;
        if (numLevels < 1) {
            return;
        }
        double minimum = this.values_[0];
        double maximum = this.values_[numLevels - 1];
        double dminimum = this.data_.getMinimumValue();
        double dmaximum = this.data_.getMaximumValue();
        int minIndex = 0;
        while (minimum <= dminimum) {
            if (++minIndex == numLevels) {
                return;
            }
            minimum = this.values_[minIndex];
        }
        int maxIndex = numLevels - 1;
        while (maximum >= dmaximum) {
            if (--maxIndex < 0) {
                return;
            }
            maximum = this.values_[maxIndex];
        }
        numLevels = maxIndex - minIndex + 1;
        this.numCols_ = this.data_.getWidth();
        this.numRows_ = this.data_.getHeight();
        Segment[][][][] segments = new Segment[numLevels][this.numCols_][this.numRows_][2];
        double value = 0.0;
        int j = 0;
        while (j + 2 < this.numRows_ - 1) {
            double valTR = this.data_.valueAt(0, j);
            double valBR = this.data_.valueAt(0, j + 2);
            int i = 0;
            while (i + 2 < this.numCols_ - 1) {
                boolean badBR;
                boolean badTR;
                boolean badBL;
                double valTL = valTR;
                double valBL = valBR;
                valTR = this.data_.valueAt(i + 2, j);
                valBR = this.data_.valueAt(i + 2, j + 2);
                boolean badTL = Double.isNaN(valTL);
                boolean badAny = badTL | (badBL = Double.isNaN(valBL)) | (badTR = Double.isNaN(valTR)) | (badBR = Double.isNaN(valBR));
                if (!(badAny || valTL < minimum && valBL < minimum && valTR < minimum && valBR < minimum || valTL > maximum && valBL > maximum && valTR > maximum && valBR > maximum)) {
                    double valAve = 0.25 * (valTL + valTR + valBR + valBL);
                    block21: for (int k = 0; k < numLevels; ++k) {
                        value = this.values_[minIndex + k];
                        boolean lowTL = valTL < value;
                        boolean lowBL = valBL < value;
                        boolean lowTR = valTR < value;
                        boolean lowBR = valBR < value;
                        boolean lowAve = valAve < value;
                        int corners = 0;
                        if (lowTL) {
                            corners |= 1;
                        }
                        if (lowTR) {
                            corners |= 2;
                        }
                        if (lowBR) {
                            corners |= 4;
                        }
                        if (lowBL) {
                            corners |= 8;
                        }
                        switch (corners) {
                            case 0: {
                                continue block21;
                            }
                            case 1: {
                                segments[k][i][j][0] = new Segment(3, 0);
                                continue block21;
                            }
                            case 2: {
                                segments[k][i][j][0] = new Segment(0, 1);
                                continue block21;
                            }
                            case 3: {
                                segments[k][i][j][0] = new Segment(3, 1);
                                continue block21;
                            }
                            case 4: {
                                segments[k][i][j][0] = new Segment(1, 2);
                                continue block21;
                            }
                            case 5: {
                                if (lowAve) {
                                    segments[k][i][j][0] = new Segment(3, 0);
                                    segments[k][i][j][1] = new Segment(1, 2);
                                    continue block21;
                                }
                                segments[k][i][j][0] = new Segment(3, 2);
                                segments[k][i][j][1] = new Segment(1, 0);
                                continue block21;
                            }
                            case 6: {
                                segments[k][i][j][0] = new Segment(0, 2);
                                continue block21;
                            }
                            case 7: {
                                segments[k][i][j][0] = new Segment(3, 2);
                                continue block21;
                            }
                            case 8: {
                                segments[k][i][j][0] = new Segment(2, 3);
                                continue block21;
                            }
                            case 9: {
                                segments[k][i][j][0] = new Segment(2, 0);
                                continue block21;
                            }
                            case 10: {
                                if (lowAve) {
                                    segments[k][i][j][0] = new Segment(2, 3);
                                    segments[k][i][j][1] = new Segment(0, 1);
                                    continue block21;
                                }
                                segments[k][i][j][0] = new Segment(0, 3);
                                segments[k][i][j][1] = new Segment(2, 1);
                                continue block21;
                            }
                            case 11: {
                                segments[k][i][j][0] = new Segment(2, 1);
                                continue block21;
                            }
                            case 12: {
                                segments[k][i][j][0] = new Segment(1, 3);
                                continue block21;
                            }
                            case 13: {
                                segments[k][i][j][0] = new Segment(1, 0);
                                continue block21;
                            }
                            case 14: {
                                segments[k][i][j][0] = new Segment(0, 3);
                                continue block21;
                            }
                        }
                    }
                }
                i += 2;
            }
            j += 2;
        }
        this.levels_ = new ContourLevels(numLevels);
        for (int k = 0; k < numLevels; ++k) {
            value = this.values_[minIndex + k];
            ContourLevel level = new ContourLevel(value);
            int j2 = 0;
            while (j2 + 2 < this.numRows_ - 1) {
                int i = 0;
                while (i + 2 < this.numCols_ - 1) {
                    for (int ii = 0; ii < 2; ++ii) {
                        ContourLine line;
                        if (segments[k][i][j2][ii] == null || (line = this.trace(value, segments[k], i, j2, ii)) == null) continue;
                        level.addLine(line);
                    }
                    i += 2;
                }
                j2 += 2;
            }
            this.levels_.addLevel(level);
        }
    }

    private ContourLine trace(double value, Segment[][][] segments, int col, int row, int index) {
        double dy;
        double dx;
        double y1;
        double x1;
        Segment firstSegment;
        ContourLine line = new ContourLine(value);
        segments[col][row][index] = firstSegment = segments[col][row][index];
        int pcol = col;
        int prow = row;
        int pindex = index;
        block12: do {
            int ocol = pcol;
            int orow = prow;
            int oindex = pindex;
            Segment segment = segments[pcol][prow][pindex];
            if (segment == null) break;
            int side = segment.getSide(0);
            x1 = (double)pcol + 0.5;
            y1 = (double)prow + 0.5;
            dx = 2.0;
            dy = 2.0;
            double valTL = this.data_.valueAt(pcol, prow);
            double valBL = this.data_.valueAt(pcol, prow + 2);
            double valTR = this.data_.valueAt(pcol + 2, prow);
            double valBR = this.data_.valueAt(pcol + 2, prow + 2);
            int ntest = -1;
            switch (side) {
                case 0: {
                    line.addPoint(false, x1 + dx * (value - valTL) / (valTR - valTL), y1);
                    prow -= 2;
                    ntest = 2;
                    break;
                }
                case 1: {
                    line.addPoint(false, x1 + dx, y1 + dy * (value - valTR) / (valBR - valTR));
                    pcol += 2;
                    ntest = 3;
                    break;
                }
                case 2: {
                    line.addPoint(false, x1 + dx * (value - valBL) / (valBR - valBL), y1 + dy);
                    prow += 2;
                    ntest = 0;
                    break;
                }
                case 3: {
                    line.addPoint(false, x1, y1 + dy * (value - valTL) / (valBL - valTL));
                    pcol -= 2;
                    ntest = 1;
                }
            }
            segments[ocol][orow][oindex] = null;
            if (prow < 0 || prow >= this.numRows_ || pcol < 0 || pcol >= this.numCols_) break;
            pindex = -1;
            for (int ix = 0; ix < 2; ++ix) {
                Segment nseg = segments[pcol][prow][ix];
                if (nseg == null || nseg.getSide(1) != ntest) continue;
                pindex = ix;
                continue block12;
            }
        } while (pindex >= 0);
        segments[col][row][index] = firstSegment;
        int nrow = row;
        int ncol = col;
        int nindex = index;
        block14: do {
            int ocol = ncol;
            int orow = nrow;
            int oindex = nindex;
            Segment segment = segments[ncol][nrow][index];
            if (segment == null) break;
            x1 = (double)ncol + 0.5;
            y1 = (double)nrow + 0.5;
            dx = 2.0;
            dy = 2.0;
            double valTL = this.data_.valueAt(ncol, nrow);
            double valBL = this.data_.valueAt(ncol, nrow + 2);
            double valTR = this.data_.valueAt(ncol + 2, nrow);
            double valBR = this.data_.valueAt(ncol + 2, nrow + 2);
            int side = segment.getSide(1);
            int ntest = -1;
            switch (side) {
                case 0: {
                    line.addPoint(true, x1 + dx * (value - valTL) / (valTR - valTL), y1);
                    nrow -= 2;
                    ntest = 2;
                    break;
                }
                case 1: {
                    line.addPoint(true, x1 + dx, y1 + dy * (value - valTR) / (valBR - valTR));
                    ncol += 2;
                    ntest = 3;
                    break;
                }
                case 2: {
                    line.addPoint(true, x1 + dx * (value - valBL) / (valBR - valBL), y1 + dy);
                    nrow += 2;
                    ntest = 0;
                    break;
                }
                case 3: {
                    line.addPoint(true, x1, y1 + dy * (value - valTL) / (valBL - valTL));
                    ncol -= 2;
                    ntest = 1;
                }
            }
            segments[ocol][orow][oindex] = null;
            if (nrow < 0 || nrow >= this.numRows_ || ncol < 0 || ncol >= this.numCols_) break;
            nindex = -1;
            for (int ix = 0; ix < 2; ++ix) {
                Segment nseg = segments[ncol][nrow][ix];
                if (nseg == null || nseg.getSide(0) != ntest) continue;
                nindex = ix;
                continue block14;
            }
        } while (nindex >= 0);
        return line;
    }

    class Segment {
        int inSide_;
        int outSide_;

        Segment(int inSide, int outSide) {
            this.inSide_ = inSide;
            this.outSide_ = outSide;
        }

        int getSide(int index) {
            if (index == 0) {
                return this.inSide_;
            }
            if (index == 1) {
                return this.outSide_;
            }
            return -1;
        }
    }
}

