/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets;

import com.explodingpixels.util.PlatformUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WindowUtils {
    public static void makeWindowNonOpaque(Window window) {
        window.setBackground(new Color(0, 0, 0, 0));
        if (!PlatformUtils.isMac()) {
            WindowUtils.quietlyTryToMakeWindowNonOqaque(window);
        }
    }

    private static void quietlyTryToMakeWindowNonOqaque(Window window) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            method.invoke(clazz, window, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static WindowFocusListener createAndInstallRepaintWindowFocusListener(Window window) {
        WindowFocusListener windowFocusListener = new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                e.getWindow().repaint();
            }

            public void windowLostFocus(WindowEvent e) {
                e.getWindow().repaint();
            }
        };
        window.addWindowFocusListener(windowFocusListener);
        return windowFocusListener;
    }

    public static boolean isParentWindowFocused(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        return window != null && window.isFocused();
    }

    public static void installWeakWindowFocusListener(JComponent component, WindowFocusListener focusListener) {
        WindowListener weakFocusListener = WindowUtils.createWeakWindowFocusListener(focusListener);
        AncestorListener ancestorListener = WindowUtils.createAncestorListener(component, weakFocusListener);
        component.addAncestorListener(ancestorListener);
    }

    private static WindowListener createWeakWindowFocusListener(WindowFocusListener windowFocusListener) {
        final WeakReference<WindowFocusListener> weakReference = new WeakReference<WindowFocusListener>(windowFocusListener);
        return new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                if (weakReference.get() != null) {
                    ((WindowFocusListener)weakReference.get()).windowGainedFocus(e);
                }
            }

            public void windowDeactivated(WindowEvent e) {
                if (weakReference.get() != null) {
                    ((WindowFocusListener)weakReference.get()).windowLostFocus(e);
                }
            }
        };
    }

    public static void installJComponentRepainterOnWindowFocusChanged(JComponent component) {
        WindowListener windowListener = WindowUtils.createWeakWindowFocusListener(WindowUtils.createRepaintWindowListener(component));
        AncestorListener ancestorListener = WindowUtils.createAncestorListener(component, windowListener);
        component.addAncestorListener(ancestorListener);
    }

    private static AncestorListener createAncestorListener(JComponent component, final WindowListener windowListener) {
        final WeakReference<JComponent> weakReference = new WeakReference<JComponent>(component);
        return new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                Window window;
                Window window2 = window = weakReference.get() == null ? null : SwingUtilities.getWindowAncestor((Component)weakReference.get());
                if (window != null) {
                    window.removeWindowListener(windowListener);
                    window.addWindowListener(windowListener);
                }
            }

            public void ancestorRemoved(AncestorEvent event) {
                Window window;
                Window window2 = window = weakReference.get() == null ? null : SwingUtilities.getWindowAncestor((Component)weakReference.get());
                if (window != null) {
                    window.removeWindowListener(windowListener);
                }
            }

            public void ancestorMoved(AncestorEvent event) {
            }
        };
    }

    private static WindowFocusListener createRepaintWindowListener(final JComponent component) {
        return new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                component.repaint();
            }

            public void windowDeactivated(WindowEvent e) {
                component.repaint();
            }
        };
    }
}

