/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.macwidgets.plaf.HudPaintingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class HudRadioButtonUI
extends BasicRadioButtonUI {
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        HudPaintingUtils.initHudComponent(b);
        b.setIconTextGap(5);
        this.icon = new DotIcon();
    }

    public void paint(Graphics g, JComponent c) {
        HudPaintingUtils.updateGraphicsToPaintDisabledControlIfNecessary((Graphics2D)g, c);
        super.paint(g, c);
    }

    protected void paintText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        FontMetrics fontMetrics = g.getFontMetrics(button.getFont());
        int mnemonicIndex = button.getDisplayedMnemonicIndex();
        g.setColor(button.getForeground());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fontMetrics.getAscent() + this.getTextShiftOffset());
    }

    private static class DotIcon
    implements Icon {
        private final int RADIO_BUTTON_SIZE = 13;
        private final float DOT_DIAMETER = 4.25f;

        private DotIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton button = (AbstractButton)c;
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.translate(x, y);
            HudPaintingUtils.paintHudControlBackground(graphics, button, 13, 13, HudPaintingUtils.Roundedness.RADIO);
            this.drawDotIfNecessary(graphics, button.getModel());
            graphics.dispose();
        }

        private void drawDotIfNecessary(Graphics2D graphics, ButtonModel model) {
            if (model.isSelected()) {
                this.drawSelected(graphics, model);
            }
        }

        private void drawSelected(Graphics2D graphics, ButtonModel model) {
            Color color = model.isPressed() ? HudPaintingUtils.PRESSED_MARK_COLOR : HudPaintingUtils.FONT_COLOR;
            graphics.setColor(color);
            float offset = ((float)this.getIconWidth() - 4.25f) / 2.0f;
            Ellipse2D.Float dot = new Ellipse2D.Float(offset, offset, 4.25f, 4.25f);
            graphics.fill(dot);
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }
}

