/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.FontFactory;
import com.lowagie.text.ListItem;
import com.lowagie.text.TextElementArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class List
implements TextElementArray {
    public static final boolean ORDERED = true;
    public static final boolean UNORDERED = false;
    public static final boolean NUMBERICAL = false;
    public static final boolean ALPHABETICAL = true;
    public static final boolean UPPERCASE = false;
    public static final boolean LOWERCASE = true;
    protected ArrayList list = new ArrayList();
    protected boolean numbered;
    protected boolean lettered;
    protected boolean lowercase;
    protected boolean autoindent;
    protected boolean alignindent;
    protected int first = 1;
    protected Chunk symbol = new Chunk("-");
    protected float indentationLeft = 0.0f;
    protected float indentationRight = 0.0f;
    protected float symbolIndent;
    protected Properties markupAttributes;

    public List() {
        this(false, false);
    }

    public List(boolean bl) {
        this(bl, false);
    }

    public List(boolean bl, boolean bl2) {
        this.numbered = bl;
        this.lettered = bl2;
        this.autoindent = true;
        this.alignindent = true;
    }

    public List(boolean bl, float f) {
        this(bl, false, f);
    }

    public List(boolean bl, boolean bl2, float f) {
        this.numbered = bl;
        this.lettered = bl2;
        this.symbolIndent = f;
    }

    public List(Properties properties) {
        String string = (String)properties.remove("listsymbol");
        if (string == null) {
            string = "-";
        }
        this.symbol = new Chunk(string, FontFactory.getFont(properties));
        string = (String)properties.remove("numbered");
        if (string != null) {
            this.numbered = Boolean.valueOf(string);
        }
        if ((string = (String)properties.remove("lettered")) != null) {
            this.lettered = Boolean.valueOf(string);
            if (this.numbered && this.lettered) {
                this.numbered = false;
            }
        }
        if ((string = (String)properties.remove("symbolindent")) != null) {
            this.symbolIndent = Float.parseFloat(string);
        }
        if ((string = (String)properties.remove("first")) != null) {
            char c = string.charAt(0);
            if (Character.isLetter(c)) {
                this.setFirst(c);
            } else {
                this.setFirst(Integer.parseInt(string));
            }
        }
        if ((string = (String)properties.remove("indentationleft")) != null) {
            this.setIndentationLeft(Float.parseFloat(string + "f"));
        }
        if ((string = (String)properties.remove("indentationright")) != null) {
            this.setIndentationRight(Float.parseFloat(string + "f"));
        }
    }

    public boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                elementListener.add((Element)iterator.next());
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 14;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public boolean add(Object object) {
        if (object instanceof ListItem) {
            ListItem listItem = (ListItem)object;
            if (this.numbered || this.lettered) {
                int n = this.first + this.list.size();
                Chunk chunk = this.lettered ? new Chunk(this.lowercase ? List.getLowerCaseLetter(n) : List.getUpperCaseLetter(n), this.symbol.font()) : new Chunk(String.valueOf(this.first + this.list.size()), this.symbol.font());
                chunk.append(". ");
                listItem.setListSymbol(chunk);
            } else {
                listItem.setListSymbol(this.symbol);
            }
            listItem.setIndentationLeft(this.symbolIndent, this.autoindent);
            listItem.setIndentationRight(0.0f);
            this.list.add(listItem);
        } else {
            if (object instanceof List) {
                List list = (List)object;
                list.setIndentationLeft(list.indentationLeft() + this.symbolIndent);
                --this.first;
                return this.list.add(list);
            }
            if (object instanceof String) {
                return this.add(new ListItem((String)object));
            }
        }
        return false;
    }

    public void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    public void setFirst(int n) {
        this.first = n;
    }

    public void setListSymbol(Chunk chunk) {
        this.symbol = chunk;
    }

    public void setListSymbol(String string) {
        this.symbol = new Chunk(string);
    }

    public ArrayList getItems() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    public float leading() {
        if (this.list.size() < 1) {
            return -1.0f;
        }
        ListItem listItem = (ListItem)this.list.get(0);
        return listItem.leading();
    }

    public boolean isNumbered() {
        return this.numbered;
    }

    public float symbolIndent() {
        return this.symbolIndent;
    }

    public Chunk symbol() {
        return this.symbol;
    }

    public int first() {
        return this.first;
    }

    public float indentationLeft() {
        return this.indentationLeft;
    }

    public float indentationRight() {
        return this.indentationRight;
    }

    public static boolean isSymbol(String string) {
        return "listsymbol".equals(string);
    }

    public static boolean isTag(String string) {
        return "list".equals(string);
    }

    public static String getLowerCaseLetter(int n) {
        if (n < 1) {
            return "";
        }
        --n;
        int n2 = 1;
        int n3 = 0;
        int n4 = 26;
        while (n >= n4 + n3) {
            ++n2;
            n3 += n4;
            n4 *= 26;
        }
        int n5 = n - n3;
        char[] cArray = new char[n2];
        while (n2 > 0) {
            cArray[--n2] = (char)(97 + n5 % 26);
            n5 /= 26;
        }
        return new String(cArray);
    }

    public static String getUpperCaseLetter(int n) {
        return List.getLowerCaseLetter(n).toUpperCase();
    }

    public void setLowerCase(boolean bl) {
        this.lowercase = bl;
    }

    public void setAutoindent(boolean bl) {
        this.autoindent = bl;
    }

    public void normalizeIndentation() {
        Element element;
        float f = 0.0f;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (!(element instanceof ListItem)) continue;
            f = Math.max(f, ((ListItem)element).indentationLeft());
        }
        iterator = this.list.iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (!(element instanceof ListItem)) continue;
            ((ListItem)element).setIndentationLeft(f);
        }
    }

    public boolean isAlignindent() {
        return this.alignindent;
    }

    public void setAlignindent(boolean bl) {
        this.alignindent = bl;
    }
}

