/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;
import com.lowagie.text.TextElementArray;
import java.util.ArrayList;
import java.util.Properties;

public class Chapter
extends Section
implements TextElementArray {
    private static final long serialVersionUID = 1791000695779357361L;

    public Chapter(int number) {
        super(null, 1);
        this.numbers = new ArrayList();
        this.numbers.add(new Integer(number));
        this.triggerNewPage = true;
    }

    public Chapter(Paragraph title, int number) {
        super(title, 1);
        this.numbers = new ArrayList();
        this.numbers.add(new Integer(number));
        this.triggerNewPage = true;
    }

    public Chapter(String title, int number) {
        this(new Paragraph(title), number);
    }

    public Chapter(Properties attributes, int number) {
        this(new Paragraph(""), number);
        String value = (String)attributes.remove("numberdepth");
        if (value != null) {
            this.setNumberDepth(Integer.parseInt(value));
        }
        if ((value = (String)attributes.remove("indent")) != null) {
            this.setIndentation(Float.parseFloat(String.valueOf(value) + "f"));
        }
        if ((value = (String)attributes.remove("indentationleft")) != null) {
            this.setIndentationLeft(Float.parseFloat(String.valueOf(value) + "f"));
        }
        if ((value = (String)attributes.remove("indentationright")) != null) {
            this.setIndentationRight(Float.parseFloat(String.valueOf(value) + "f"));
        }
    }

    public int type() {
        return 16;
    }

    public static boolean isTag(String tag) {
        return "chapter".equals(tag);
    }
}

