/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Contour2D;
import visad.Control;
import visad.ControlListener;
import visad.DisplayEvent;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.VisADException;
import visad.browser.Convert;
import visad.util.Util;

public class ContourControl
extends Control {
    private static final long serialVersionUID = 1L;
    public static final int LABEL_FREQ_LO = 1;
    public static final int LABEL_FREQ_MED = 5;
    public static final int LABEL_FREQ_HI = 9;
    private boolean mainContours = true;
    private float surfaceValue = Float.NaN;
    private float contourInterval = Float.NaN;
    private float lowLimit = Float.NaN;
    private float hiLimit = Float.NaN;
    private float base = Float.NaN;
    private boolean labels = false;
    private int labelFreq = 1;
    private boolean public_set = false;
    private boolean arithmeticProgression = true;
    private float[] levels = null;
    private int lineStyle = 0;
    private boolean dash = false;
    private boolean horizontalContourSlice = false;
    private boolean verticalContourSlice = false;
    private float horizontalSliceLow = Float.NaN;
    private float horizontalSliceHi = Float.NaN;
    private float horizontalSliceStep = Float.NaN;
    private float verticalSliceLow = Float.NaN;
    private float verticalSliceHi = Float.NaN;
    private float verticalSliceStep = Float.NaN;
    boolean contourFill = false;
    private static double init_scale = Double.NaN;
    private static double default_init_scale = 0.4;
    private boolean autoSizeLabels = true;
    private boolean alignLabels = true;
    private double labelSizeFactor = 1.0;
    private transient ZoomDoneListener zoom;
    private ProjectionControl pcntrl;
    private ControlListener projListener;
    private double ratio = 1.2;
    private byte[] labelColor = null;
    private boolean colorSet = false;
    private Object labelFont = null;

    public ContourControl(DisplayImpl d) {
        super(d);
        double projScale;
        this.pcntrl = d.getProjectionControl();
        double[] matrix = this.pcntrl.getMatrix();
        double[] rot = new double[3];
        double[] trans = new double[3];
        double[] scale = new double[1];
        MouseBehavior mouse = d.getMouseBehavior();
        if (mouse != null) {
            mouse.instance_unmake_matrix(rot, scale, trans, matrix);
            if (init_scale != init_scale) {
                init_scale = scale[0];
            }
            projScale = scale[0];
        } else {
            projScale = init_scale = default_init_scale;
        }
        this.zoom = new ZoomDoneListener(this, this.pcntrl, mouse, projScale);
        d.addDisplayListener(this.zoom);
    }

    void setMainContours(boolean[] bvalues, float[] fvalues) throws VisADException, RemoteException {
        this.setMainContours(bvalues, fvalues, false, false);
    }

    void setMainContours(boolean[] bvalues, float[] fvalues, boolean noChange) throws VisADException, RemoteException {
        this.setMainContours(bvalues, fvalues, noChange, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMainContours(boolean[] bvalues, float[] fvalues, boolean noChange, boolean override) throws VisADException, RemoteException {
        if (fvalues == null || fvalues.length != 5 || bvalues == null || bvalues.length != 2) {
            throw new DisplayException("ContourControl.setMainContours: bad array length");
        }
        boolean setLevels = false;
        float[] levs = null;
        boolean[] dashes = null;
        float myBase = 0.0f;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            this.mainContours = bvalues[0];
            this.labels = bvalues[1];
            if (override) {
                this.surfaceValue = fvalues[0];
                this.contourInterval = fvalues[1];
                this.lowLimit = fvalues[2];
                this.hiLimit = fvalues[3];
                this.base = fvalues[4];
            } else {
                if (this.surfaceValue != this.surfaceValue) {
                    this.surfaceValue = fvalues[0];
                }
                if (this.contourInterval != this.contourInterval) {
                    this.contourInterval = fvalues[1];
                }
                if (this.lowLimit != this.lowLimit) {
                    this.lowLimit = fvalues[2];
                }
                if (this.hiLimit != this.hiLimit) {
                    this.hiLimit = fvalues[3];
                }
                if (this.base != this.base) {
                    this.base = fvalues[4];
                }
            }
            if (this.arithmeticProgression) {
                if (this.contourInterval == this.contourInterval && this.base == this.base && this.lowLimit == this.lowLimit && this.hiLimit == this.hiLimit) {
                    dashes = new boolean[]{false};
                    levs = Contour2D.intervalToLevels(this.contourInterval, this.lowLimit, this.hiLimit, this.base, dashes);
                    myBase = this.base;
                    setLevels = true;
                } else {
                    this.dash = false;
                    this.levels = null;
                }
            }
        }
        if (setLevels) {
            this.setLevels(levs, myBase, (boolean)dashes[0], false);
        }
        this.changeControl(!noChange);
    }

    public void setSurfaceValue(float value) throws VisADException, RemoteException {
        this.setSurfaceValue(value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurfaceValue(float value, boolean setLevels) throws VisADException, RemoteException {
        boolean change;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            change = !Util.isApproximatelyEqual(this.surfaceValue, value);
            this.surfaceValue = value;
            if (setLevels) {
                this.levels = new float[]{value};
            }
        }
        if (change) {
            this.changeControl(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContourInterval(float interval, float low, float hi, float ba) throws VisADException, RemoteException {
        float[] levs;
        float myBase;
        boolean change;
        this.public_set = true;
        boolean[] dashes = new boolean[]{false};
        ContourControl contourControl = this;
        synchronized (contourControl) {
            change = this.contourInterval != interval || this.base != ba || !Util.isApproximatelyEqual(this.lowLimit, low) || !Util.isApproximatelyEqual(this.hiLimit, hi);
            this.contourInterval = interval;
            this.lowLimit = low;
            this.hiLimit = hi;
            myBase = this.base = ba;
            levs = Contour2D.intervalToLevels(this.contourInterval, this.lowLimit, this.hiLimit, this.base, dashes);
            this.arithmeticProgression = true;
        }
        this.setLevels(levs, myBase, dashes[0], change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContourLimits(float low, float hi) throws VisADException, RemoteException {
        boolean setLevels;
        boolean change;
        this.public_set = true;
        float[] levs = null;
        float myBase = 0.0f;
        boolean[] dashes = null;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            change = !Util.isApproximatelyEqual(this.lowLimit, low) || !Util.isApproximatelyEqual(this.hiLimit, hi);
            this.lowLimit = low;
            this.hiLimit = hi;
            if (this.arithmeticProgression) {
                setLevels = true;
                dashes = new boolean[]{false};
                levs = Contour2D.intervalToLevels(this.contourInterval, this.lowLimit, this.hiLimit, this.base, dashes);
                myBase = this.base;
            } else {
                setLevels = false;
                int n = 0;
                for (int i = 0; i < this.levels.length; ++i) {
                    if (!(this.lowLimit < this.levels[i]) || !(this.levels[i] < this.hiLimit)) continue;
                    ++n;
                }
                if (n != this.levels.length) {
                    levs = new float[n];
                    int k = 0;
                    for (int i = 0; i < this.levels.length; ++i) {
                        if (!(this.lowLimit < this.levels[i]) || !(this.levels[i] < this.hiLimit)) continue;
                        levs[k++] = this.levels[i];
                    }
                    this.levels = levs;
                } else {
                    change = false;
                }
            }
        }
        if (setLevels) {
            this.setLevels(levs, myBase, dashes[0], false);
        }
        if (change) {
            this.changeControl(true);
        }
    }

    public boolean getPublicSet() {
        return this.public_set;
    }

    public void setLevels(float[] levels, float base, boolean dash) throws VisADException, RemoteException {
        this.public_set = true;
        this.setLevels(levels, base, dash, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLevels(float[] levs, float ba, boolean da, boolean by_user) throws VisADException, RemoteException {
        if (levs == null) {
            return;
        }
        float[] newLevels = new float[levs.length];
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 0; i < levs.length; ++i) {
            if (levs[i] < min) {
                min = levs[i];
            }
            if (levs[i] > max) {
                max = levs[i];
            }
            newLevels[i] = levs[i];
        }
        ContourControl contourControl = this;
        synchronized (contourControl) {
            this.levels = newLevels;
            this.dash = da;
            this.base = ba;
            if (by_user) {
                this.lowLimit = min - Math.abs(0.01f * min);
                this.hiLimit = max + Math.abs(0.01f * max);
            }
        }
        if (by_user) {
            this.changeControl(true);
        }
    }

    public synchronized float[] getLevels(float[] lowhibase, boolean[] dashes) {
        float[] levs = null;
        if (this.levels != null) {
            levs = new float[this.levels.length];
            System.arraycopy(this.levels, 0, levs, 0, this.levels.length);
        }
        lowhibase[0] = this.lowLimit;
        lowhibase[1] = this.hiLimit;
        lowhibase[2] = this.base;
        dashes[0] = this.dash;
        return levs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableLabels(boolean on) throws VisADException, RemoteException {
        boolean change;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            change = this.labels != on;
            this.labels = on;
        }
        if (change) {
            this.changeControl(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableContours(boolean on) throws VisADException, RemoteException {
        boolean change;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            change = this.mainContours != on;
            this.mainContours = on;
        }
        if (change) {
            this.changeControl(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMainContours(boolean[] bvalues, float[] fvalues) throws VisADException {
        if (fvalues == null || fvalues.length != 5 || bvalues == null || bvalues.length != 2) {
            throw new DisplayException("ContourControl.getMainContours: bad array length");
        }
        ContourControl contourControl = this;
        synchronized (contourControl) {
            bvalues[0] = this.mainContours;
            bvalues[1] = this.labels;
            fvalues[0] = this.surfaceValue;
            fvalues[1] = this.contourInterval;
            fvalues[2] = this.lowLimit;
            fvalues[3] = this.hiLimit;
            fvalues[4] = this.base;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContourFill(boolean flag) throws VisADException, RemoteException {
        if (flag) {
            if (!this.colorSet) {
                this.labelColor = new byte[]{-1, -1, -1, -1};
            }
        } else if (!this.colorSet) {
            this.labelColor = null;
        }
        ContourControl contourControl = this;
        synchronized (contourControl) {
            this.contourFill = flag;
        }
        this.changeControl(true);
    }

    public synchronized boolean contourFilled() {
        return this.contourFill;
    }

    public static double getInitScale() {
        return init_scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoScaleLabels(boolean flag) {
        ContourControl contourControl = this;
        synchronized (contourControl) {
            this.autoSizeLabels = flag;
        }
    }

    public boolean getAutoSizeLabels() {
        return this.autoSizeLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlignLabels(boolean flag) throws RemoteException, VisADException {
        ContourControl contourControl = this;
        synchronized (contourControl) {
            this.alignLabels = flag;
        }
        this.changeControl(true);
    }

    public boolean getAlignLabels() {
        return this.alignLabels;
    }

    public void setLabelColor(byte[] color) throws RemoteException, VisADException {
        this.setLabelColor(color, true);
    }

    public void setLabelColor(byte[] color, boolean change) throws RemoteException, VisADException {
        this.labelColor = color;
        this.colorSet = true;
        this.changeControl(change);
    }

    public byte[] getLabelColor() {
        return this.labelColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabelFont(Object font) throws RemoteException, VisADException {
        ContourControl contourControl = this;
        synchronized (contourControl) {
            this.labelFont = font;
        }
        this.changeControl(true);
    }

    public Object getLabelFont() {
        return this.labelFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabelFreq(int freq) throws VisADException, RemoteException {
        ContourControl contourControl = this;
        synchronized (contourControl) {
            this.labelFreq = this.labelFreq < 1 || this.labelFreq > 9 ? 1 : freq;
        }
        this.changeControl(true);
    }

    public int getLabelFreq() {
        return this.labelFreq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabelSize(double factor) throws VisADException, RemoteException {
        ContourControl contourControl = this;
        synchronized (contourControl) {
            this.labelSizeFactor *= factor;
        }
        this.changeControl(true);
    }

    public double getLabelSize() {
        return this.labelSizeFactor;
    }

    public int getDashedStyle() {
        return this.lineStyle;
    }

    public void setDashedStyle(int style) throws RemoteException, VisADException {
        this.lineStyle = style;
        this.changeControl(true);
    }

    public synchronized String getSaveString() {
        return this.mainContours + " " + this.labels + " " + this.surfaceValue + " " + this.contourInterval + " " + this.lowLimit + " " + this.hiLimit + " " + this.base;
    }

    public void setSaveString(String save) throws VisADException, RemoteException {
        int i;
        if (save == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer st = new StringTokenizer(save);
        if (st.countTokens() < 7) {
            throw new VisADException("Invalid save string");
        }
        boolean[] b = new boolean[2];
        float[] f = new float[5];
        for (i = 0; i < 2; ++i) {
            b[i] = Convert.getBoolean(st.nextToken());
        }
        for (i = 0; i < 5; ++i) {
            f[i] = Convert.getFloat(st.nextToken());
        }
        this.setMainContours(b, f, false, true);
    }

    public void addProjectionControlListener(ControlListener cl, ProjectionControl pcntrl) {
        pcntrl.removeControlListener(this.projListener);
        this.projListener = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof ContourControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        ContourControl cc = (ContourControl)rmt;
        boolean changed = false;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            ContourControl contourControl2 = cc;
            synchronized (contourControl2) {
                if (this.mainContours != cc.mainContours) {
                    changed = true;
                    this.mainContours = cc.mainContours;
                }
                if (!Util.isApproximatelyEqual(this.surfaceValue, cc.surfaceValue)) {
                    changed = true;
                    this.surfaceValue = cc.surfaceValue;
                }
                if (!Util.isApproximatelyEqual(this.contourInterval, cc.contourInterval)) {
                    changed = true;
                    this.contourInterval = cc.contourInterval;
                }
                if (!Util.isApproximatelyEqual(this.lowLimit, cc.lowLimit)) {
                    changed = true;
                    this.lowLimit = cc.lowLimit;
                }
                if (!Util.isApproximatelyEqual(this.hiLimit, cc.hiLimit)) {
                    changed = true;
                    this.hiLimit = cc.hiLimit;
                }
                if (!Util.isApproximatelyEqual(this.base, cc.base)) {
                    changed = true;
                    this.base = cc.base;
                }
                if (this.labels != cc.labels) {
                    changed = true;
                    this.labels = cc.labels;
                }
                if (this.arithmeticProgression != cc.arithmeticProgression) {
                    changed = true;
                    this.arithmeticProgression = cc.arithmeticProgression;
                }
                if (cc.levels == null) {
                    if (this.levels != null) {
                        changed = true;
                        this.levels = null;
                    }
                } else {
                    int i;
                    if (this.levels == null || this.levels.length != cc.levels.length) {
                        changed = true;
                        this.levels = new float[cc.levels.length];
                        for (i = 0; i < this.levels.length; ++i) {
                            this.levels[i] = 0.0f;
                        }
                    }
                    for (i = 0; i < this.levels.length; ++i) {
                        if (Util.isApproximatelyEqual(this.levels[i], cc.levels[i])) continue;
                        changed = true;
                        this.levels[i] = cc.levels[i];
                    }
                }
                if (this.dash != cc.dash) {
                    changed = true;
                    this.dash = cc.dash;
                }
                if (this.horizontalContourSlice != cc.horizontalContourSlice) {
                    changed = true;
                    this.horizontalContourSlice = cc.horizontalContourSlice;
                }
                if (this.verticalContourSlice != cc.verticalContourSlice) {
                    changed = true;
                    this.verticalContourSlice = cc.verticalContourSlice;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceLow, cc.horizontalSliceLow)) {
                    changed = true;
                    this.horizontalSliceLow = cc.horizontalSliceLow;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceHi, cc.horizontalSliceHi)) {
                    changed = true;
                    this.horizontalSliceHi = cc.horizontalSliceHi;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceStep, cc.horizontalSliceStep)) {
                    changed = true;
                    this.horizontalSliceStep = cc.horizontalSliceStep;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceLow, cc.verticalSliceLow)) {
                    changed = true;
                    this.verticalSliceLow = cc.verticalSliceLow;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceHi, cc.verticalSliceHi)) {
                    changed = true;
                    this.verticalSliceHi = cc.verticalSliceHi;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceStep, cc.verticalSliceStep)) {
                    changed = true;
                    this.verticalSliceStep = cc.verticalSliceStep;
                }
                if (this.contourFill != cc.contourFill) {
                    changed = true;
                    this.contourFill = cc.contourFill;
                }
                if (this.autoSizeLabels != cc.autoSizeLabels) {
                    changed = true;
                    this.autoSizeLabels = cc.autoSizeLabels;
                }
                if (this.labelSizeFactor != cc.labelSizeFactor) {
                    changed = true;
                    this.labelSizeFactor = cc.labelSizeFactor;
                }
                if (this.alignLabels != cc.alignLabels) {
                    changed = true;
                    this.alignLabels = cc.alignLabels;
                }
                if (this.labelFont != cc.labelFont) {
                    changed = true;
                    this.labelFont = cc.labelFont;
                }
            }
        }
        if (changed) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ContourControl cc = (ContourControl)o;
        ContourControl contourControl = this;
        synchronized (contourControl) {
            ContourControl contourControl2 = cc;
            synchronized (contourControl2) {
                if (this.mainContours != cc.mainContours) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.surfaceValue, cc.surfaceValue)) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.contourInterval, cc.contourInterval)) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.lowLimit, cc.lowLimit)) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.hiLimit, cc.hiLimit)) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.base, cc.base)) {
                    return false;
                }
                if (this.labels != cc.labels) {
                    return false;
                }
                if (this.arithmeticProgression != cc.arithmeticProgression) {
                    return false;
                }
                if (this.levels == null) {
                    if (cc.levels != null) {
                        return false;
                    }
                } else {
                    if (cc.levels == null || this.levels.length != cc.levels.length) {
                        return false;
                    }
                    for (int i = 0; i < this.levels.length; ++i) {
                        if (Util.isApproximatelyEqual(this.levels[i], cc.levels[i])) continue;
                        return false;
                    }
                }
                if (this.dash != cc.dash) {
                    return false;
                }
                if (this.horizontalContourSlice != cc.horizontalContourSlice) {
                    return false;
                }
                if (this.verticalContourSlice != cc.verticalContourSlice) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceLow, cc.horizontalSliceLow)) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceHi, cc.horizontalSliceHi)) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.horizontalSliceStep, cc.horizontalSliceStep)) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceLow, cc.verticalSliceLow)) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceHi, cc.verticalSliceHi)) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.verticalSliceStep, cc.verticalSliceStep)) {
                    return false;
                }
                if (this.contourFill != cc.contourFill) {
                    return false;
                }
                if (this.autoSizeLabels != cc.autoSizeLabels) {
                    return false;
                }
                if (this.alignLabels != cc.alignLabels) {
                    return false;
                }
                if (this.labelFont != cc.labelFont) {
                    return false;
                }
                if (!Util.isApproximatelyEqual(this.labelSizeFactor, cc.labelSizeFactor)) {
                    return false;
                }
            }
        }
        return true;
    }

    public synchronized Object clone() {
        ContourControl cc = (ContourControl)super.clone();
        if (this.levels != null) {
            cc.levels = (float[])this.levels.clone();
        }
        cc.lineStyle = this.lineStyle;
        return cc;
    }

    public void reLabel() throws VisADException, RemoteException {
        if (this.zoom == null || this.contourFill) {
            return;
        }
        this.zoom.reLabel(this.ratio);
    }

    public void nullControl() {
        if (this.projListener != null) {
            this.pcntrl.removeControlListener(this.projListener);
        }
        this.getDisplay().removeDisplayListener(this.zoom);
        this.zoom = null;
        super.nullControl();
    }

    class ZoomDoneListener
    implements DisplayListener {
        ContourControl c_cntrl;
        ProjectionControl p_cntrl;
        MouseBehavior mouse;
        double last_scale;

        ZoomDoneListener(ContourControl c_cntrl, ProjectionControl p_cntrl, MouseBehavior mouse, double scale) {
            this.c_cntrl = c_cntrl;
            this.p_cntrl = p_cntrl;
            this.mouse = mouse;
            this.last_scale = scale;
        }

        public void displayChanged(DisplayEvent de) throws VisADException, RemoteException {
            if (de.getId() == 9 || de.getId() == 10) {
                this.reLabel(ContourControl.this.ratio);
            }
        }

        public void reLabel(double ratio) throws VisADException, RemoteException {
            if (!this.c_cntrl.contourFilled() && ContourControl.this.autoSizeLabels) {
                double[] matrix = this.p_cntrl.getMatrix();
                double[] rot = new double[3];
                double[] trans = new double[3];
                double[] scale = new double[1];
                this.mouse.instance_unmake_matrix(rot, scale, trans, matrix);
                if (scale[0] / this.last_scale > ratio || scale[0] / this.last_scale < 1.0 / ratio) {
                    if (ContourControl.this.labels) {
                        this.c_cntrl.changeControl(true);
                    }
                    this.last_scale = scale[0];
                }
            }
        }
    }
}

