/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridDefRecord;
import ucar.grib.grib1.Grib1GDSVariables;
import ucar.grib.grib1.Grib1GridTableLookup;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.iosp.grid.GridDefRecord;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridTableLookup;
import ucar.nc2.iosp.grid.GridVertCoord;

public class GribVertCoord
extends GridVertCoord {
    private static Logger logger = LoggerFactory.getLogger(GribVertCoord.class);

    GribVertCoord(String name) {
        super(name);
    }

    GribVertCoord(List<GridRecord> records, String levelName, GridTableLookup lookup, GridHorizCoordSys hcs) {
        super(records, levelName, lookup, hcs);
        if (this.typicalRecord.getLevelType1() == 109 && lookup instanceof Grib1GridTableLookup) {
            GridDefRecord gdr = hcs.getGds();
            Grib1GDSVariables g1dr = (Grib1GDSVariables)((GribGridDefRecord)gdr).getGdsv();
            if (g1dr == null || !g1dr.hasVerticalPressureLevels()) {
                return;
            }
            this.coordValues = new double[this.levels.size()];
            for (int i = 0; i < this.levels.size(); ++i) {
                GridVertCoord.LevelCoord lc = (GridVertCoord.LevelCoord)this.levels.get(i);
                this.coordValues[i] = lc.value1;
            }
            int NV = g1dr.getNV();
            if (NV > 2 && NV < 255) {
                this.factors = g1dr.getVerticalPressureLevels();
            }
        }
    }

    @Override
    protected String getLevelDesc() {
        String desc = this.lookup.getLevelDescription(this.typicalRecord);
        if (this.lookup instanceof Grib2GridTableLookup && this.usesBounds) {
            desc = "Layer between " + desc;
        }
        return desc;
    }

    @Override
    protected void addExtraAttributes(Variable v) {
        v.addAttribute(new Attribute("GRIB_level_type", Integer.toString(this.typicalRecord.getLevelType1())));
    }
}

