/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CF;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.gempak.AbstractGempakStationFileReader;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakParameters;
import ucar.nc2.iosp.gempak.GempakStation;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;
import visad.util.Trace;

public abstract class GempakStationFileIOSP
extends AbstractIOServiceProvider {
    protected NetcdfFile ncfile;
    protected AbstractGempakStationFileReader gemreader;
    protected StringBuilder parseInfo = new StringBuilder();
    private DateFormatter dateFormat = new DateFormatter();
    protected static final Number RMISS = new Float(-9999.0f);
    protected static final Number IMISS = new Integer(-9999);
    protected static final Dimension DIM_LEN8 = new Dimension("len8", 8, true);
    protected static final Dimension DIM_LEN4 = new Dimension("len4", 4, true);
    protected static final Dimension DIM_LEN2 = new Dimension("len2", 2, true);
    protected static final String TIME_VAR = "time";
    protected static final String MISSING_VAR = "_isMissing";
    private static String[] stnVarNames = new String[]{"STID", "STNM", "SLAT", "SLON", "SELV", "STAT", "COUN", "STD2", "SPRI", "SWFO", "WFO2"};
    private static int[] stnVarSizes = new int[]{8, 4, 4, 4, 4, 2, 2, 4, 4, 4, 4};

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        try {
            this.gemreader = this.makeStationReader();
            Trace.call1("GEMPAKSIOSP.isValidFile: reader.init");
            this.gemreader.init(raf, false);
            Trace.call2("GEMPAKSIOSP.isValidFile: reader.init");
        }
        catch (Exception ioe) {
            return false;
        }
        return true;
    }

    protected abstract AbstractGempakStationFileReader makeStationReader();

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.ncfile = ncfile;
        long start = System.currentTimeMillis();
        if (this.gemreader == null) {
            this.gemreader = this.makeStationReader();
        }
        Trace.call1("GEMPAKStationIOSP.open: initTables");
        this.initTables();
        Trace.call2("GEMPAKStationIOSP.open: initTables");
        Trace.call1("GEMPAKStationIOSP.open: reader.init");
        this.gemreader.init(raf, true);
        Trace.call2("GEMPAKStationIOSP.open: reader.init");
        this.buildNCFile();
    }

    private void initTables() {
        try {
            GempakParameters.addParameters("resources/nj22/tables/gempak/params.tbl");
        }
        catch (Exception e) {
            System.out.println("unable to init param tables");
        }
    }

    @Override
    public String getDetailInfo() {
        Formatter ff = new Formatter();
        ff.format("%s", super.getDetailInfo());
        ff.format("%s", this.parseInfo);
        return ff.toString();
    }

    public boolean sync() throws IOException {
        if (this.gemreader.getInitFileSize() < this.raf.length()) {
            long start = System.currentTimeMillis();
            Trace.msg("GEMPAKStationIOSP.sync: file " + this.raf.getLocation() + " is bigger: " + this.raf.length() + " > " + this.gemreader.getInitFileSize());
            Trace.call1("GEMPAKStationIOSP.sync: reader.init");
            this.gemreader.init(this.raf, true);
            Trace.call2("GEMPAKStationIOSP.sync: reader.init");
            Trace.call1("GEMPAKStationIOSP.sync: buildNCFile");
            this.buildNCFile();
            Trace.call2("GEMPAKSIOSP.sync: buildNCFile");
            return true;
        }
        return false;
    }

    protected void buildNCFile() throws IOException {
        Trace.call1("GEMPAKSIOSP: buildNCFile");
        this.ncfile.empty();
        this.fillNCFile();
        this.addGlobalAttributes();
        this.ncfile.finish();
        Trace.call2("GEMPAKSIOSP: buildNCFile");
    }

    protected abstract void fillNCFile() throws IOException;

    protected Structure makeStructure(String partName, List dimensions, boolean includeMissing) {
        List<GempakParameter> params = this.gemreader.getParameters(partName);
        if (params == null) {
            return null;
        }
        Structure sVar = new Structure(this.ncfile, null, null, partName);
        sVar.setDimensions(dimensions);
        for (GempakParameter param : params) {
            sVar.addMemberVariable(this.makeParamVariable(param, null));
        }
        if (includeMissing) {
            sVar.addMemberVariable(this.makeMissingVariable());
        }
        return sVar;
    }

    protected Variable makeMissingVariable() {
        Variable var = new Variable(this.ncfile, null, null, MISSING_VAR);
        var.setDataType(DataType.BYTE);
        var.setDimensions((List<Dimension>)null);
        var.addAttribute(new Attribute("description", "missing flag - 1 means all params are missing"));
        var.addAttribute(new Attribute("missing_value", new Byte(1)));
        return var;
    }

    protected Variable makeParamVariable(GempakParameter param, List<Dimension> dims) {
        Variable var = new Variable(this.ncfile, null, null, param.getName());
        var.setDataType(DataType.FLOAT);
        var.setDimensions(dims);
        var.addAttribute(new Attribute("long_name", param.getDescription()));
        String units = param.getUnit();
        if (units != null && !units.equals("")) {
            var.addAttribute(new Attribute("units", units));
        }
        var.addAttribute(new Attribute("missing_value", RMISS));
        return var;
    }

    protected void addGlobalAttributes() {
        this.ncfile.addAttribute(null, new Attribute("Conventions", this.getConventions()));
        String fileType = "GEMPAK " + this.gemreader.getFileType();
        this.ncfile.addAttribute(null, new Attribute("file_format", fileType));
        this.ncfile.addAttribute(null, new Attribute("history", "Direct read of " + fileType + " into NetCDF-Java API"));
        this.ncfile.addAttribute(null, new Attribute("featureType", this.getCFFeatureType()));
    }

    public String getConventions() {
        return "GEMPAK/CDM";
    }

    public String getCFFeatureType() {
        return CF.FeatureType.point.toString();
    }

    protected int getStnVarSize(String name) {
        int size = -1;
        for (int i = 0; i < stnVarNames.length; ++i) {
            if (!name.equals(stnVarNames[i])) continue;
            size = stnVarSizes[i];
            break;
        }
        return size;
    }

    protected List<Variable> makeStationVars(List<GempakStation> stations, Dimension dim) {
        int numStations = stations.size();
        boolean useSTID = true;
        for (GempakStation station : stations) {
            if (!station.getSTID().equals("")) continue;
            useSTID = false;
            break;
        }
        ArrayList<Variable> vars = new ArrayList<Variable>();
        List<String> stnKeyNames = this.gemreader.getStationKeyNames();
        for (String varName : stnKeyNames) {
            Variable v = this.makeStationVariable(varName, dim);
            Attribute stIDAttr = new Attribute("standard_name", "station_id");
            if (varName.equals("STID") && useSTID) {
                v.addAttribute(stIDAttr);
            }
            if (varName.equals("STNM") && !useSTID) {
                v.addAttribute(stIDAttr);
            }
            vars.add(v);
        }
        if (dim != null && numStations > 0) {
            for (Variable v : vars) {
                Array varArray;
                if (v.getDataType().equals((Object)DataType.CHAR)) {
                    int[] shape = v.getShape();
                    varArray = new ArrayChar.D2(shape[0], shape[1]);
                } else {
                    varArray = this.get1DArray(v.getDataType(), numStations);
                }
                int index = 0;
                String varname = v.getFullName();
                for (GempakStation stn : stations) {
                    String test = "";
                    if (varname.equals("STID")) {
                        test = stn.getName();
                    } else if (varname.equals("STNM")) {
                        ((ArrayInt.D1)varArray).set(index, stn.getSTNM());
                    } else if (varname.equals("SLAT")) {
                        ((ArrayFloat.D1)varArray).set(index, (float)stn.getLatitude());
                    } else if (varname.equals("SLON")) {
                        ((ArrayFloat.D1)varArray).set(index, (float)stn.getLongitude());
                    } else if (varname.equals("SELV")) {
                        ((ArrayFloat.D1)varArray).set(index, (float)stn.getAltitude());
                    } else if (varname.equals("STAT")) {
                        test = stn.getSTAT();
                    } else if (varname.equals("COUN")) {
                        test = stn.getCOUN();
                    } else if (varname.equals("STD2")) {
                        test = stn.getSTD2();
                    } else if (varname.equals("SPRI")) {
                        ((ArrayInt.D1)varArray).set(index, stn.getSPRI());
                    } else if (varname.equals("SWFO")) {
                        test = stn.getSWFO();
                    } else if (varname.equals("WFO2")) {
                        test = stn.getWFO2();
                    }
                    if (!test.equals("")) {
                        ((ArrayChar.D2)varArray).setString(index, test);
                    }
                    ++index;
                }
                v.setCachedData(varArray, false);
            }
        }
        return vars;
    }

    private Array get1DArray(DataType type, int len) {
        Array varArray = null;
        if (type.equals((Object)DataType.FLOAT)) {
            varArray = new ArrayFloat.D1(len);
        } else if (type.equals((Object)DataType.DOUBLE)) {
            varArray = new ArrayDouble.D1(len);
        } else if (type.equals((Object)DataType.INT)) {
            varArray = new ArrayInt.D1(len);
        }
        return varArray;
    }

    protected Variable makeStationVariable(String varname, Dimension firstDim) {
        String longName = varname;
        String unit = null;
        DataType type = DataType.CHAR;
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        if (firstDim != null) {
            dims.add(firstDim);
        }
        if (varname.equals("STID")) {
            longName = "Station identifier";
            dims.add(DIM_LEN8);
        } else if (varname.equals("STNM")) {
            longName = "WMO station id";
            type = DataType.INT;
        } else if (varname.equals("SLAT")) {
            longName = "latitude";
            unit = "degrees_north";
            type = DataType.FLOAT;
            attrs.add(new Attribute("standard_name", "latitude"));
        } else if (varname.equals("SLON")) {
            longName = "longitude";
            unit = "degrees_east";
            type = DataType.FLOAT;
            attrs.add(new Attribute("standard_name", "longitude"));
        } else if (varname.equals("SELV")) {
            longName = "altitude";
            unit = "meter";
            type = DataType.FLOAT;
            attrs.add(new Attribute("positive", "up"));
            attrs.add(new Attribute("standard_name", "station_altitude"));
        } else if (varname.equals("STAT")) {
            longName = "state or province";
            dims.add(DIM_LEN2);
        } else if (varname.equals("COUN")) {
            longName = "country code";
            dims.add(DIM_LEN2);
        } else if (varname.equals("STD2")) {
            longName = "Extended station id";
            dims.add(DIM_LEN4);
        } else if (varname.equals("SPRI")) {
            longName = "Station priority";
            type = DataType.INT;
        } else if (varname.equals("SWFO")) {
            longName = "WFO code";
            dims.add(DIM_LEN4);
        } else if (varname.equals("WFO2")) {
            longName = "Second WFO code";
            dims.add(DIM_LEN4);
        }
        Variable v = new Variable(this.ncfile, null, null, varname);
        v.setDataType(type);
        v.addAttribute(new Attribute("long_name", longName));
        if (unit != null) {
            v.addAttribute(new Attribute("units", unit));
        }
        if (type.equals((Object)DataType.FLOAT)) {
            v.addAttribute(new Attribute("missing_value", RMISS));
        } else if (type.equals((Object)DataType.INT)) {
            v.addAttribute(new Attribute("missing_value", IMISS));
        }
        if (!attrs.isEmpty()) {
            for (Attribute attr : attrs) {
                v.addAttribute(attr);
            }
        }
        if (!dims.isEmpty()) {
            v.setDimensions(dims);
        } else {
            v.setDimensions((String)null);
        }
        return v;
    }

    protected void printStack(String msg, int maxLines) {
        String trace = this.getStackTrace();
        if (msg != null) {
            System.out.println(msg);
        }
        StringTokenizer tok = new StringTokenizer(trace, "\n");
        int allcnt = 0;
        int cnt = 0;
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            if (++allcnt <= 4) continue;
            System.out.println(line);
            if (++cnt <= maxLines) continue;
            break;
        }
    }

    protected String getStackTrace() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new IllegalArgumentException("").printStackTrace(new PrintStream(baos));
        return baos.toString();
    }
}

