/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.adde;

import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import ucar.ma2.Array;
import ucar.nc2.iosp.adde.AreaFile3;

public class AddeImage {
    private static int initialCapacity = 100;
    private static Map<String, AddeImage> hash = new LinkedHashMap<String, AddeImage>(initialCapacity, 0.75f, true);
    private static double memUsed = 0.0;
    private static int maxCacheSize = 30;
    private static boolean debugCache = false;
    private String urlName;
    private int nelems = 0;
    private int nlines = 0;
    private Array ma;

    public static AddeImage factory(String urlName) throws IOException {
        AddeImage image = hash.get(urlName);
        if (image == null) {
            if (debugCache) {
                System.out.println("ADDE/AddeImage/ShowCache: cache miss " + urlName);
            }
            image = new AddeImage(urlName);
            hash.put(urlName, image);
            memUsed += (double)image.getSize();
            AddeImage.adjustCache();
        } else if (debugCache) {
            System.out.println("ADDE/AddeImage/ShowCache: cache hit " + urlName);
        }
        if (debugCache) {
            System.out.println("  memUsed = " + memUsed * 1.0E-6 + " Mb");
        }
        return image;
    }

    public static int getMaxCacheSize() {
        return maxCacheSize;
    }

    public static void setMaxCacheSize(int max) {
        maxCacheSize = max;
    }

    public static int getCacheSize() {
        return (int)(memUsed * 1.0E-6);
    }

    private static void adjustCache() {
        double max = (double)maxCacheSize * 1000000.0;
        if (memUsed <= max) {
            return;
        }
        Iterator<AddeImage> iter = hash.values().iterator();
        while (iter.hasNext() && memUsed > max) {
            AddeImage image = iter.next();
            memUsed -= (double)image.getSize();
            if (debugCache) {
                System.out.println("  remove = " + image.getName() + " size= " + (double)image.getSize() * 1.0E-6 + "  memUsed = " + memUsed * 1.0E-6);
            }
            iter.remove();
        }
    }

    public AddeImage(String urlName) throws IOException, MalformedURLException {
        this.urlName = urlName;
        long timeStart = System.currentTimeMillis();
        boolean debug = false;
        AreaFile3 areaFile2 = new AreaFile3(urlName);
        this.ma = areaFile2.getData();
        if (this.ma.getRank() == 3) {
            this.ma = this.ma.slice(0, 0);
        }
        this.nlines = this.ma.getShape()[0];
        this.nelems = this.ma.getShape()[1];
        long timeEnd = System.currentTimeMillis();
    }

    private long getSize() {
        return this.getSize(this.ma);
    }

    private long getSize(Array ma) {
        long size = ma.getSize();
        Class maType = ma.getElementType();
        if (maType == Byte.TYPE) {
            return size;
        }
        if (maType == Short.TYPE) {
            return 2L * size;
        }
        if (maType == Integer.TYPE) {
            return 4L * size;
        }
        if (maType == Float.TYPE) {
            return 4L * size;
        }
        if (maType == Double.TYPE) {
            return 8L * size;
        }
        throw new IllegalArgumentException("DataBufferMultiArray ma has illegal data type = " + maType.getName());
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.nelems, this.nlines);
    }

    public String getName() {
        return this.urlName;
    }
}

