/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.LocalTables;

public class FslLocalTables
extends LocalTables {
    private static final String tableName = "resources/grib2/local/Fsl-hrrr.csv";
    private static boolean debug = false;
    private String tableNameUsed;

    static FslLocalTables localFactory(int center, int subCenter, int masterVersion, int localVersion) {
        return new FslLocalTables(center, subCenter, masterVersion, localVersion);
    }

    private FslLocalTables(int center, int subCenter, int masterVersion, int localVersion) {
        super(center, subCenter, masterVersion, localVersion);
    }

    @Override
    public String getTablePath(int discipline, int category, int number) {
        if (category <= 191 && number <= 191) {
            return super.getTablePath(discipline, category, number);
        }
        return this.tableNameUsed;
    }

    @Override
    public String getSubCenterName(int center, int subcenter) {
        switch (subcenter) {
            case 0: {
                return null;
            }
            case 1: {
                return "FSL/FRD Regional Analysis and Prediction Branch";
            }
            case 2: {
                return "FSL/FRD Local Analysis and Prediction Branch";
            }
        }
        return super.getSubCenterName(center, subcenter);
    }

    @Override
    public String getGeneratingProcessName(int genProcess) {
        switch (genProcess) {
            case 106: {
                return "Developmental Testbed Center Winter Field Experiment, WRF-ARW";
            }
            case 112: {
                return "Developmental Testbed Center Winter Field Experiment, WRF-NMM";
            }
            case 116: {
                return "FIM Model from NOAA/ESRL/Global Systems Division";
            }
            case 125: {
                return "High-Resolution Rapid Refresh";
            }
        }
        return null;
    }

    @Override
    public String getLevelNameShort(int id) {
        if (id < 192) {
            return super.getLevelNameShort(id);
        }
        switch (id) {
            case 200: {
                return "Entire_atmosphere";
            }
        }
        return null;
    }

    @Override
    public String getLevelName(int id) {
        if (id < 192) {
            return super.getLevelName(id);
        }
        switch (id) {
            case 200: {
                return "Entire atmosphere layer";
            }
        }
        return null;
    }

    @Override
    public String getIntervalNameShort(int id) {
        switch (id) {
            case 255: {
                return "Interval";
            }
        }
        return super.getIntervalNameShort(id);
    }

    @Override
    protected void initLocalTable() {
        this.local = this.initLocalTable(tableName, null);
    }

    @Override
    public void lookForProblems(Formatter f) {
        this.initLocalTable(this.tableNameUsed, f);
    }

    private Map<Integer, Grib2Parameter> initLocalTable(String resourcePath, Formatter f) {
        this.tableNameUsed = resourcePath;
        boolean header = true;
        HashMap<Integer, Grib2Parameter> result = new HashMap<Integer, Grib2Parameter>(100);
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(resourcePath);
        if (is == null) {
            throw new IllegalStateException("Cant find " + resourcePath);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        HashMap<String, Grib2Parameter> names = new HashMap<String, Grib2Parameter>(200);
        try {
            String line;
            while (!(line = br.readLine()).startsWith("Record")) {
            }
            while ((line = br.readLine()) != null) {
                Grib2Parameter dup;
                if (line.length() == 0 || line.startsWith("#")) continue;
                String[] flds = line.split(",");
                String RecordNumber = flds[0].trim();
                int TableNumber = Integer.parseInt(flds[1].trim());
                int DisciplineNumber = Integer.parseInt(flds[2].trim());
                int CategoryNumber = Integer.parseInt(flds[3].trim());
                int ParameterNumber = Integer.parseInt(flds[4].trim());
                String WGrib2Name = flds[5].trim();
                String NCLName = flds[6].trim();
                String FieldType2 = flds[7].trim();
                String Description2 = flds[8].trim();
                String Units = flds[9].trim();
                if (debug) {
                    System.out.printf("%3s %3d %3d %3d %3d %-10s %-25s %-30s %-100s %-20s%n", RecordNumber, TableNumber, DisciplineNumber, CategoryNumber, ParameterNumber, WGrib2Name, NCLName, FieldType2, Description2, Units);
                }
                String name = WGrib2Name != null && !WGrib2Name.equals("var") ? WGrib2Name : FieldType2;
                Grib2Parameter s = new Grib2Parameter(DisciplineNumber, CategoryNumber, ParameterNumber, name, Units, null, Description2);
                s.desc = Description2;
                result.put(FslLocalTables.makeHash(DisciplineNumber, CategoryNumber, ParameterNumber), s);
                if (debug) {
                    System.out.printf(" %s%n", s);
                }
                if ((CategoryNumber > 191 || ParameterNumber > 191) && (dup = (Grib2Parameter)names.get(s.getName())) != null && f != null) {
                    if (header) {
                        f.format("Problems in table %s %n", resourcePath);
                    }
                    header = false;
                    f.format(" DUPLICATE NAME %s and %s (%s)%n", s.getId(), dup.getId(), s.getName());
                }
                names.put(s.getName(), s);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return result;
    }

    public static void main(String[] args) {
        FslLocalTables t = new FslLocalTables(59, 0, 0, 0);
        Formatter f = new Formatter();
        Grib2Parameter.compareTables("FSL-HRRR", "Standard WMO version 8", t.getParameters(), Grib2Customizer.factory(0, 0, 0, 0), f);
        System.out.printf("%s%n", f);
        Formatter f2 = new Formatter();
        Grib2Parameter.compareTables("FSL-HRRR", "NCEP Table", t.getParameters(), Grib2Customizer.factory(7, 0, 0, 0), f2);
        System.out.printf("%s%n", f2);
    }
}

