/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.ncml.NcMLReader;
import ucar.unidata.util.StringUtil2;

public class Grib1ParamTable {
    private static final Logger logger = LoggerFactory.getLogger(Grib1ParamTable.class);
    private static final boolean debug = false;
    private int center_id;
    private int subcenter_id;
    private int version;
    private String name;
    private String path;
    private Map<Integer, Grib1Parameter> parameters;
    private boolean useName;
    private static final Pattern nclPattern = Pattern.compile("\\{(\\d*)\\,\\s*\"([^\"]*)\"\\,\\s*\"([^\"]*)\"\\,\\s*\"([^\"]*)\".*");

    public Grib1ParamTable(String path) throws IOException {
        this.path = StringUtil2.replace(path, "\\", "/");
        this.name = GribResourceReader.getFilename(path);
        this.parameters = this.readParameterTable();
    }

    public Grib1ParamTable(int center_id, int subcenter_id, int version, String path) {
        this.center_id = center_id;
        this.subcenter_id = subcenter_id;
        this.version = version;
        this.path = path;
        this.name = GribResourceReader.getFilename(path);
    }

    public Grib1ParamTable(Element paramTableElem) throws IOException {
        this.name = paramTableElem.getChildText("title");
        DssParser p = new DssParser(NcMLReader.ncNS);
        this.parameters = p.parseXml(paramTableElem);
    }

    public int getCenter_id() {
        return this.center_id;
    }

    public int getSubcenter_id() {
        return this.subcenter_id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public boolean useParamName() {
        return this.useName;
    }

    public int getKey() {
        return Grib1ParamTables.makeKey(this.center_id, this.subcenter_id, this.version);
    }

    public String getPath() {
        return this.path;
    }

    public Map<Integer, Grib1Parameter> getParameters() {
        if (this.parameters == null) {
            this.readParameterTable();
        }
        return this.parameters;
    }

    public void setParameters(Map<Integer, Grib1Parameter> params) {
        this.parameters = params;
    }

    public Grib1Parameter getParameter(int id) {
        if (this.parameters == null) {
            this.readParameterTable();
        }
        Grib1Parameter p = this.parameters.get(id);
        return p;
    }

    public Grib1Parameter getLocalParameter(int id) {
        if (this.parameters == null) {
            this.readParameterTable();
        }
        return this.parameters.get(id);
    }

    public String toString() {
        return "Grib1ParamTable{center_id=" + this.center_id + ", subcenter_id=" + this.subcenter_id + ", version=" + this.version + ", name='" + this.name + '\'' + ", path='" + this.path + '\'' + '}';
    }

    private Map<Integer, Grib1Parameter> readParameterTable() {
        if (this.name.startsWith("table_2_") || this.name.startsWith("local_table_2_")) {
            this.readParameterTableEcmwf();
        } else if (this.name.startsWith("US058")) {
            this.readParameterTableXml(new FnmocParser());
        } else if (this.name.endsWith(".tab")) {
            this.readParameterTableTab();
        } else if (this.name.endsWith(".wrf")) {
            this.readParameterTableSplit("\\|", new int[]{0, 3, 1, 2});
        } else if (this.name.endsWith(".h")) {
            this.readParameterTableNcl();
        } else if (this.name.endsWith(".dss")) {
            this.readParameterTableSplit("\t", new int[]{0, -1, 1, 2});
        } else if (this.name.endsWith(".xml")) {
            this.readParameterTableXml(new DssParser(Namespace.NO_NAMESPACE));
        } else {
            logger.warn("Dont know how to read " + this.name + " file=" + this.path);
        }
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableNcl() {
        boolean line2;
        HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
        InputStream is = null;
        try {
            String line;
            is = GribResourceReader.getInputStream(this.path);
            if (is == null) {
                boolean bl = false;
                return bl;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            int count = 0;
            while ((line = br.readLine()) != null && !line.startsWith("TBLE2")) {
                if (line.contains("Center:")) {
                    this.center_id = this.extract(line, "Center:");
                } else if (line.contains("Subcenter:")) {
                    this.subcenter_id = this.extract(line, "Subcenter:");
                } else if (line.contains("version:")) {
                    this.version = this.extract(line, "version:");
                }
                ++count;
            }
            while ((line = br.readLine()) != null) {
                int p1;
                Matcher m;
                if (line.length() == 0 || line.startsWith("#") || !(m = nclPattern.matcher(line)).matches()) continue;
                try {
                    p1 = Integer.parseInt(m.group(1));
                }
                catch (Exception e) {
                    logger.warn("Cant parse " + m.group(1) + " in file " + this.path);
                    continue;
                }
                Grib1Parameter parameter = new Grib1Parameter(this, p1, m.group(4), m.group(2), m.group(3));
                result.put(parameter.getNumber(), parameter);
            }
            this.parameters = result;
            line2 = true;
        }
        catch (IOException ioError) {
            logger.warn("An error occurred in Grib1ParamTable while trying to open the parameter table " + this.path + " : " + ioError);
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return line2;
    }

    private int extract(String line, String key) {
        int pos = line.indexOf(key);
        if (pos < 0) {
            return -1;
        }
        String want = line.substring(pos + key.length());
        try {
            return Integer.parseInt(want.trim());
        }
        catch (NumberFormatException e) {
            System.out.printf("BAD %s (%s)%n", line, this.path);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableEcmwf() {
        boolean num2;
        HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
        InputStream is = null;
        try {
            is = GribResourceReader.getInputStream(this.path);
            if (is == null) {
                logger.error("Cant open " + this.path);
                boolean bl = false;
                return bl;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            if (!line.startsWith("...")) {
                this.name = line;
            }
            while (!line.startsWith("...")) {
                line = br.readLine();
            }
            while ((line = br.readLine()) != null) {
                int p1;
                String notes;
                if (line.length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("...") && (line = br.readLine()) == null) break;
                String num2 = line.trim();
                line = br.readLine();
                String name = line != null ? line.trim() : null;
                line = br.readLine();
                String desc = line != null ? line.trim() : null;
                line = br.readLine();
                String units1 = line != null ? line.trim() : null;
                line = br.readLine();
                String string = notes = line == null || line.startsWith("...") ? null : line.trim();
                if (desc.equalsIgnoreCase("undefined")) continue;
                try {
                    p1 = Integer.parseInt(num2);
                }
                catch (Exception e) {
                    logger.warn("Cant parse " + num2 + " in file " + this.path);
                    continue;
                }
                Grib1Parameter parameter = new Grib1Parameter(this, p1, name, desc, units1);
                result.put(parameter.getNumber(), parameter);
            }
            this.parameters = result;
            num2 = true;
        }
        catch (IOException ioError) {
            logger.warn("An error occurred in Grib1ParamTable while trying to open the parameter table " + this.path + " : " + ioError);
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return num2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableXml(XmlTableParser parser) {
        boolean bl;
        InputStream is = null;
        try {
            is = GribResourceReader.getInputStream(this.path);
            if (is == null) {
                boolean bl2 = false;
                return bl2;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            this.parameters = parser.parseXml(root);
            bl = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            boolean bl3 = false;
            return bl3;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            boolean bl4 = false;
            return bl4;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableSplit(String regexp, int[] order) {
        boolean bl;
        HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
        InputStream is = null;
        try {
            String line;
            is = GribResourceReader.getInputStream(this.path);
            if (is == null) {
                boolean bl2 = false;
                return bl2;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                String[] flds = line.split(regexp);
                int p1 = Integer.parseInt(flds[order[0]].trim());
                String name = order[1] >= 0 ? flds[order[1]].trim() : null;
                String desc = flds[order[2]].trim();
                String units = flds.length > order[3] ? flds[order[3]].trim() : "";
                Grib1Parameter parameter = new Grib1Parameter(this, p1, name, desc, units);
                result.put(parameter.getNumber(), parameter);
            }
            this.parameters = result;
            bl = true;
        }
        catch (IOException ioError) {
            logger.warn("An error occurred in Grib1ParamTable while trying to open the parameter table " + this.path + " : " + ioError);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readParameterTableTab() {
        boolean line22;
        if (this.path == null) {
            logger.error("Grib1ParamTable: unknown path for " + this);
            return false;
        }
        InputStream is = null;
        try {
            String line22;
            is = GribResourceReader.getInputStream(this.path);
            if (is == null) {
                logger.error("Grib1ParamTable: error getInputStream on " + this);
                boolean bl = false;
                return bl;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            br.readLine();
            HashMap<Integer, Grib1Parameter> params = new HashMap<Integer, Grib1Parameter>();
            while ((line22 = br.readLine()) != null) {
                Grib1Parameter parameter;
                String units;
                String desc;
                if (line22.length() == 0 || line22.startsWith("#")) continue;
                String[] tableDefArr = line22.split(":");
                int p1 = Integer.parseInt(tableDefArr[0].trim());
                String name = tableDefArr[1].trim();
                if (tableDefArr[2].indexOf(91) == -1) {
                    desc = tableDefArr[2].trim();
                    units = "";
                } else {
                    String[] arr2 = tableDefArr[2].split("\\[");
                    desc = arr2[0].trim();
                    units = arr2[1].substring(0, arr2[1].lastIndexOf(93)).trim();
                }
                if ((parameter = new Grib1Parameter(this, p1, name, desc, units)).getDescription().equalsIgnoreCase("undefined")) continue;
                params.put(parameter.getNumber(), parameter);
            }
            this.parameters = params;
            line22 = true;
        }
        catch (IOException ioError) {
            logger.warn("An error occurred in Grib1ParamTable while trying to open the parameter table " + this.path + " : " + ioError);
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return line22;
    }

    public static void main(String[] args) throws IOException {
        String dirS = "C:\\dev\\github\\thredds\\grib\\src\\main\\resources\\resources\\grib1\\ncl";
        File dir = new File(dirS);
        for (File f : dir.listFiles()) {
            if (!f.getName().endsWith(".h")) continue;
            Grib1ParamTable table = new Grib1ParamTable(f.getPath());
            System.out.printf("%5d: %5d: %5d: %s%n", table.getCenter_id(), table.getSubcenter_id(), table.getVersion(), table.getName());
        }
    }

    private class FnmocParser
    implements XmlTableParser {
        private FnmocParser() {
        }

        @Override
        public HashMap<Integer, Grib1Parameter> parseXml(Element root) {
            HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
            Element fnmocTable = root.getChild("fnmocTable");
            List<Element> params = fnmocTable.getChildren("entry");
            for (Element elem1 : params) {
                int code;
                try {
                    code = Integer.parseInt(elem1.getChildText("grib1Id"));
                }
                catch (NumberFormatException e) {
                    System.out.printf("BAD number= %s%n", elem1.getChildText("grib1Id"));
                    continue;
                }
                String desc = elem1.getChildText("description");
                if (desc == null) continue;
                desc = StringUtil2.collapseWhitespace(desc);
                String units = elem1.getChildText("unitsFNMOC");
                if (units == null) {
                    units = "";
                }
                String name = elem1.getChildText("name");
                Grib1Parameter parameter = new Grib1Parameter(Grib1ParamTable.this, code, name, desc, units, null);
                result.put(parameter.getNumber(), parameter);
            }
            Grib1ParamTable.this.useName = true;
            return result;
        }
    }

    private class DssParser
    implements XmlTableParser {
        private Namespace ns;

        DssParser(Namespace ns) {
            this.ns = ns;
        }

        @Override
        public HashMap<Integer, Grib1Parameter> parseXml(Element root) {
            HashMap<Integer, Grib1Parameter> result = new HashMap<Integer, Grib1Parameter>();
            List<Element> params = root.getChildren("parameter", this.ns);
            for (Element elem1 : params) {
                String name;
                int code = Integer.parseInt(elem1.getAttributeValue("code"));
                String desc = elem1.getChildText("description", this.ns);
                if (desc == null) continue;
                String units = elem1.getChildText("units", this.ns);
                if (units == null) {
                    units = "";
                }
                if ((name = elem1.getChildText("name", this.ns)) == null) {
                    name = elem1.getChildText("shortName", this.ns);
                }
                String cf = elem1.getChildText("CF", this.ns);
                Grib1Parameter parameter = new Grib1Parameter(Grib1ParamTable.this, code, name, desc, units, cf);
                result.put(parameter.getNumber(), parameter);
            }
            return result;
        }
    }

    private static interface XmlTableParser {
        public HashMap<Integer, Grib1Parameter> parseXml(Element var1);
    }
}

