/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.util.ArrayList;
import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.DArray;
import ucar.ma2.DataType;
import ucar.nc2.DODSNode;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSAttribute;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DodsV;

public class DODSVariable
extends Variable
implements DODSNode {
    protected String CE;
    protected DODSNetcdfFile dodsfile;
    String dodsName = null;

    DODSVariable(DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String dodsShortName, DodsV dodsV) {
        super(dodsfile, parentGroup, parentStructure, DODSNetcdfFile.makeShortName(dodsShortName));
        this.setDODSName(DODSNetcdfFile.makeDODSName(dodsShortName));
        this.dodsfile = dodsfile;
        this.setSPobject(dodsV);
    }

    DODSVariable(DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String dodsShortName, BaseType dodsScalar, DodsV dodsV) {
        super(dodsfile, parentGroup, parentStructure, DODSNetcdfFile.makeShortName(dodsShortName));
        Dimension strlenDim;
        this.setDODSName(DODSNetcdfFile.makeDODSName(dodsShortName));
        this.dodsfile = dodsfile;
        this.setDataType(DODSNetcdfFile.convertToNCType(dodsScalar));
        if (DODSNetcdfFile.isUnsigned(dodsScalar)) {
            this.addAttribute(new DODSAttribute("_Unsigned", "true"));
        }
        if (this.dataType == DataType.STRING && null != (strlenDim = dodsfile.getNetcdfStrlenDim(this))) {
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            if (strlenDim.getLength() != 0) {
                dims.add(dodsfile.getSharedDimension(parentGroup, strlenDim));
            }
            this.setDimensions(dims);
            this.setDataType(DataType.CHAR);
        } else {
            this.shape = new int[0];
        }
        this.setSPobject(dodsV);
    }

    DODSVariable(DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String dodsShortName, DArray dodsArray, BaseType elemType, DodsV dodsV) {
        super(dodsfile, parentGroup, parentStructure, dodsShortName);
        Dimension strlenDim;
        this.setDODSName(DODSNetcdfFile.makeDODSName(dodsShortName));
        this.dodsfile = dodsfile;
        this.setDataType(DODSNetcdfFile.convertToNCType(elemType));
        if (DODSNetcdfFile.isUnsigned(elemType)) {
            this.addAttribute(new DODSAttribute("_Unsigned", "true"));
        }
        List<Dimension> dims = dodsfile.constructDimensions(parentGroup, dodsArray);
        if (this.dataType == DataType.STRING && null != (strlenDim = dodsfile.getNetcdfStrlenDim(this))) {
            if (strlenDim.getLength() != 0) {
                dims.add(dodsfile.getSharedDimension(parentGroup, strlenDim));
            }
            this.setDataType(DataType.CHAR);
        }
        this.setDimensions(dims);
        this.setSPobject(dodsV);
    }

    @Override
    protected Variable copy() {
        return new DODSVariable(this);
    }

    protected DODSVariable(DODSVariable from) {
        super(from);
        this.setDODSName(from.getDODSName());
        this.dodsfile = from.dodsfile;
        this.CE = from.CE;
    }

    protected void setCE(String CE) {
        this.CE = CE;
    }

    protected boolean hasCE() {
        return this.CE != null;
    }

    protected String nameWithCE() {
        return this.hasCE() ? this.getShortName() + this.CE : this.getShortName();
    }

    @Override
    public String getDODSName() {
        return this.dodsName;
    }

    @Override
    public void setDODSName(String name) {
        this.dodsName = name;
    }
}

