/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import ucar.jpeg.jj2000.j2k.io.RandomAccessIO;

public class ISRandomAccessIO
implements RandomAccessIO {
    private InputStream is;
    private int maxsize;
    private int inc;
    private byte[] buf;
    private int len;
    private int pos;
    private boolean complete;

    public ISRandomAccessIO(InputStream is, int size, int inc, int maxsize) {
        if (size < 0 || inc <= 0 || maxsize <= 0 || is == null) {
            throw new IllegalArgumentException();
        }
        this.is = is;
        if (size < Integer.MAX_VALUE) {
            ++size;
        }
        this.buf = new byte[size];
        this.inc = inc;
        if (maxsize < Integer.MAX_VALUE) {
            ++maxsize;
        }
        this.maxsize = maxsize;
        this.pos = 0;
        this.len = 0;
        this.complete = false;
    }

    public ISRandomAccessIO(InputStream is) {
        this(is, 262144, 262144, Integer.MAX_VALUE);
    }

    private void growBuffer() throws IOException {
        byte[] newbuf;
        int effinc = this.inc;
        if (this.buf.length + effinc > this.maxsize) {
            effinc = this.maxsize - this.buf.length;
        }
        if (effinc <= 0) {
            throw new IOException("Reached maximum cache size (" + this.maxsize + ")");
        }
        try {
            newbuf = new byte[this.buf.length + this.inc];
        }
        catch (OutOfMemoryError e) {
            throw new IOException("Out of memory to cache input data");
        }
        System.arraycopy(this.buf, 0, newbuf, 0, this.len);
        this.buf = newbuf;
    }

    private void readInput() throws IOException {
        int k;
        if (this.complete) {
            throw new IllegalArgumentException("Already reached EOF");
        }
        int n = this.is.available();
        if (n == 0) {
            n = 1;
        }
        while (this.len + n > this.buf.length) {
            this.growBuffer();
        }
        do {
            if ((k = this.is.read(this.buf, this.len, n)) <= 0) continue;
            this.len += k;
            n -= k;
        } while (n > 0 && k > 0);
        if (k <= 0) {
            this.complete = true;
            this.is.close();
            this.is = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.buf = null;
        if (!this.complete) {
            this.is.close();
            this.is = null;
        }
    }

    @Override
    public int getPos() throws IOException {
        return this.pos;
    }

    @Override
    public void seek(int off) throws IOException {
        if (this.complete && off > this.len) {
            throw new EOFException();
        }
        this.pos = off;
    }

    @Override
    public int length() throws IOException {
        while (!this.complete) {
            this.readInput();
        }
        return this.len;
    }

    @Override
    public int read() throws IOException {
        if (this.pos < this.len) {
            return 0xFF & this.buf[this.pos++];
        }
        while (!this.complete && this.pos >= this.len) {
            this.readInput();
        }
        if (this.pos == this.len) {
            throw new EOFException();
        }
        if (this.pos > this.len) {
            throw new IOException("Position beyond EOF");
        }
        return 0xFF & this.buf[this.pos++];
    }

    @Override
    public void readFully(byte[] b, int off, int n) throws IOException {
        if (this.pos + n <= this.len) {
            System.arraycopy(this.buf, this.pos, b, off, n);
            this.pos += n;
            return;
        }
        while (!this.complete && this.pos + n > this.len) {
            this.readInput();
        }
        if (this.pos + n > this.len) {
            throw new EOFException();
        }
        System.arraycopy(this.buf, this.pos, b, off, n);
        this.pos += n;
    }

    @Override
    public int getByteOrdering() {
        return 0;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.pos < this.len) {
            return this.buf[this.pos++];
        }
        return (byte)this.read();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.pos < this.len) {
            return 0xFF & this.buf[this.pos++];
        }
        return this.read();
    }

    @Override
    public short readShort() throws IOException {
        if (this.pos + 1 < this.len) {
            return (short)(this.buf[this.pos++] << 8 | 0xFF & this.buf[this.pos++]);
        }
        return (short)(this.read() << 8 | this.read());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.pos + 1 < this.len) {
            return (0xFF & this.buf[this.pos++]) << 8 | 0xFF & this.buf[this.pos++];
        }
        return this.read() << 8 | this.read();
    }

    @Override
    public int readInt() throws IOException {
        if (this.pos + 3 < this.len) {
            return this.buf[this.pos++] << 24 | (0xFF & this.buf[this.pos++]) << 16 | (0xFF & this.buf[this.pos++]) << 8 | 0xFF & this.buf[this.pos++];
        }
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        if (this.pos + 3 < this.len) {
            return 0xFFFFFFFFL & (long)(this.buf[this.pos++] << 24 | (0xFF & this.buf[this.pos++]) << 16 | (0xFF & this.buf[this.pos++]) << 8 | 0xFF & this.buf[this.pos++]);
        }
        return 0xFFFFFFFFL & (long)(this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read());
    }

    @Override
    public long readLong() throws IOException {
        if (this.pos + 7 < this.len) {
            return (long)this.buf[this.pos++] << 56 | (long)(0xFF & this.buf[this.pos++]) << 48 | (long)(0xFF & this.buf[this.pos++]) << 40 | (long)(0xFF & this.buf[this.pos++]) << 32 | (long)(0xFF & this.buf[this.pos++]) << 24 | (long)(0xFF & this.buf[this.pos++]) << 16 | (long)(0xFF & this.buf[this.pos++]) << 8 | (long)(0xFF & this.buf[this.pos++]);
        }
        return (long)this.read() << 56 | (long)this.read() << 48 | (long)this.read() << 40 | (long)this.read() << 32 | (long)this.read() << 24 | (long)this.read() << 16 | (long)this.read() << 8 | (long)this.read();
    }

    @Override
    public float readFloat() throws IOException {
        if (this.pos + 3 < this.len) {
            return Float.intBitsToFloat(this.buf[this.pos++] << 24 | (0xFF & this.buf[this.pos++]) << 16 | (0xFF & this.buf[this.pos++]) << 8 | 0xFF & this.buf[this.pos++]);
        }
        return Float.intBitsToFloat(this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read());
    }

    @Override
    public double readDouble() throws IOException {
        if (this.pos + 7 < this.len) {
            return Double.longBitsToDouble((long)this.buf[this.pos++] << 56 | (long)(0xFF & this.buf[this.pos++]) << 48 | (long)(0xFF & this.buf[this.pos++]) << 40 | (long)(0xFF & this.buf[this.pos++]) << 32 | (long)(0xFF & this.buf[this.pos++]) << 24 | (long)(0xFF & this.buf[this.pos++]) << 16 | (long)(0xFF & this.buf[this.pos++]) << 8 | (long)(0xFF & this.buf[this.pos++]));
        }
        return Double.longBitsToDouble((long)this.read() << 56 | (long)this.read() << 48 | (long)this.read() << 40 | (long)this.read() << 32 | (long)this.read() << 24 | (long)this.read() << 16 | (long)this.read() << 8 | (long)this.read());
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (this.complete && this.pos + n > this.len) {
            throw new EOFException();
        }
        this.pos += n;
        return n;
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("read-only");
    }

    @Override
    public void writeByte(int v) throws IOException {
        throw new IOException("read-only");
    }

    @Override
    public void writeShort(int v) throws IOException {
        throw new IOException("read-only");
    }

    @Override
    public void writeInt(int v) throws IOException {
        throw new IOException("read-only");
    }

    @Override
    public void writeLong(long v) throws IOException {
        throw new IOException("read-only");
    }

    @Override
    public void writeFloat(float v) throws IOException {
        throw new IOException("read-only");
    }

    @Override
    public void writeDouble(double v) throws IOException {
        throw new IOException("read-only");
    }
}

