/*
 * Decompiled with CFR 0.152.
 */
package org.itadaki.bzip2;

import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream {
    private final OutputStream outputStream;
    private int bitBuffer;
    private int bitCount;

    public void writeBoolean(boolean value) throws IOException {
        int bitCount = this.bitCount + 1;
        int bitBuffer = this.bitBuffer | (value ? 1 : 0) << 32 - bitCount;
        if (bitCount == 8) {
            this.outputStream.write(bitBuffer >>> 24);
            bitBuffer = 0;
            bitCount = 0;
        }
        this.bitBuffer = bitBuffer;
        this.bitCount = bitCount;
    }

    public void writeUnary(int value) throws IOException {
        while (value-- > 0) {
            this.writeBoolean(true);
        }
        this.writeBoolean(false);
    }

    public void writeBits(int count, int value) throws IOException {
        int bitCount = this.bitCount;
        int bitBuffer = this.bitBuffer | value << 32 - count >>> bitCount;
        bitCount += count;
        while (bitCount >= 8) {
            this.outputStream.write(bitBuffer >>> 24);
            bitBuffer <<= 8;
            bitCount -= 8;
        }
        this.bitBuffer = bitBuffer;
        this.bitCount = bitCount;
    }

    public void writeInteger(int value) throws IOException {
        this.writeBits(16, value >>> 16 & 0xFFFF);
        this.writeBits(16, value & 0xFFFF);
    }

    public void flush() throws IOException {
        if (this.bitCount > 0) {
            this.writeBits(8 - this.bitCount, 0);
        }
    }

    public BitOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

