/*
 * Decompiled with CFR 0.152.
 */
package org.itadaki.bzip2;

import java.io.IOException;
import org.itadaki.bzip2.BZip2DivSufSort;
import org.itadaki.bzip2.BZip2HuffmanStageEncoder;
import org.itadaki.bzip2.BitOutputStream;
import org.itadaki.bzip2.CRC32;

public class BZip2BlockCompressor {
    private final BitOutputStream bitOutputStream;
    private final CRC32 crc = new CRC32();
    private final byte[] block;
    private int blockLength = 0;
    private final int blockLengthLimit;
    private final boolean[] blockValuesPresent = new boolean[256];
    private final int[] bwtBlock;
    private int rleCurrentValue = -1;
    private int rleLength = 0;

    private void writeRun(int value, int runLength) {
        int blockLength = this.blockLength;
        byte[] block = this.block;
        this.blockValuesPresent[value] = true;
        this.crc.updateCRC(value, runLength);
        byte byteValue = (byte)value;
        switch (runLength) {
            case 1: {
                block[blockLength] = byteValue;
                this.blockLength = blockLength + 1;
                break;
            }
            case 2: {
                block[blockLength] = byteValue;
                block[blockLength + 1] = byteValue;
                this.blockLength = blockLength + 2;
                break;
            }
            case 3: {
                block[blockLength] = byteValue;
                block[blockLength + 1] = byteValue;
                block[blockLength + 2] = byteValue;
                this.blockLength = blockLength + 3;
                break;
            }
            default: {
                this.blockValuesPresent[runLength -= 4] = true;
                block[blockLength] = byteValue;
                block[blockLength + 1] = byteValue;
                block[blockLength + 2] = byteValue;
                block[blockLength + 3] = byteValue;
                block[blockLength + 4] = (byte)runLength;
                this.blockLength = blockLength + 5;
            }
        }
    }

    public boolean write(int value) {
        if (this.blockLength > this.blockLengthLimit) {
            return false;
        }
        int rleCurrentValue = this.rleCurrentValue;
        int rleLength = this.rleLength;
        if (rleLength == 0) {
            this.rleCurrentValue = value;
            this.rleLength = 1;
        } else if (rleCurrentValue != value) {
            this.writeRun(rleCurrentValue & 0xFF, rleLength);
            this.rleCurrentValue = value;
            this.rleLength = 1;
        } else if (rleLength == 254) {
            this.writeRun(rleCurrentValue & 0xFF, 255);
            this.rleLength = 0;
        } else {
            this.rleLength = rleLength + 1;
        }
        return true;
    }

    public int write(byte[] data, int offset, int length) {
        int written = 0;
        while (length-- > 0) {
            if (!this.write(data[offset++])) break;
            ++written;
        }
        return written;
    }

    public void close() throws IOException {
        if (this.rleLength > 0) {
            this.writeRun(this.rleCurrentValue & 0xFF, this.rleLength);
        }
        this.block[this.blockLength] = this.block[0];
        BZip2DivSufSort divSufSort = new BZip2DivSufSort(this.block, this.bwtBlock, this.blockLength);
        int bwtStartPointer = divSufSort.bwt();
        this.bitOutputStream.writeBits(24, 3227993);
        this.bitOutputStream.writeBits(24, 2511705);
        this.bitOutputStream.writeInteger(this.crc.getCRC());
        this.bitOutputStream.writeBoolean(false);
        this.bitOutputStream.writeBits(24, bwtStartPointer);
        BZip2HuffmanStageEncoder huffmanEncoder = new BZip2HuffmanStageEncoder(this.bitOutputStream, this.blockValuesPresent, this.bwtBlock, this.blockLength);
        huffmanEncoder.encode();
    }

    public boolean isEmpty() {
        return this.blockLength == 0 && this.rleLength == 0;
    }

    public int getCRC() {
        return this.crc.getCRC();
    }

    public BZip2BlockCompressor(BitOutputStream bitOutputStream, int blockSize) {
        this.bitOutputStream = bitOutputStream;
        this.block = new byte[blockSize + 1];
        this.bwtBlock = new int[blockSize + 1];
        this.blockLengthLimit = blockSize - 6;
    }
}

