/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet.ascii;

import java.io.PrintWriter;
import java.util.Enumeration;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DString;
import opendap.dap.PrimitiveVector;
import opendap.servlet.ascii.toASCII;

public class asciiArray
extends DArray
implements toASCII {
    private static boolean _Debug = false;

    public asciiArray() {
        this(null);
    }

    public asciiArray(String n) {
        super(n);
    }

    @Override
    public void toASCII(PrintWriter pw, boolean addName, String rootName, boolean newLine) {
        if (_Debug) {
            System.out.println("asciiArray.toASCII(" + addName + ",'" + rootName + "')  getName(): " + this.getEncodedName());
            System.out.println("  PrimitiveVector size = " + this.getPrimitiveVector().getLength());
        }
        rootName = this.toASCIIAddRootName(pw, addName, rootName);
        if (addName) {
            pw.print("\n");
        }
        int dims = this.numDimensions();
        int[] shape = new int[dims];
        int i = 0;
        Enumeration e = this.getDimensions();
        while (e.hasMoreElements()) {
            DArrayDimension d = (DArrayDimension)e.nextElement();
            shape[i++] = d.getSize();
        }
        int totalCount = this.asciiArray(pw, addName, "", 0, dims, shape, 0);
        if (newLine) {
            pw.print("\n");
        }
    }

    @Override
    public String toASCIIFlatName(String rootName) {
        String s = "";
        s = rootName != null ? rootName + "." + this.getEncodedName() : this.getEncodedName();
        String s2 = "";
        PrimitiveVector pv = this.getPrimitiveVector();
        if (pv instanceof BaseTypePrimitiveVector) {
            BaseType bt = ((BaseTypePrimitiveVector)pv).getValue(0);
            if (bt instanceof DString) {
                int dims = this.numDimensions();
                boolean i = false;
                Enumeration e = this.getDimensions();
                while (e.hasMoreElements()) {
                    DArrayDimension d = (DArrayDimension)e.nextElement();
                    s = s + "[" + d.getSize() + "]";
                }
                s2 = s;
            } else {
                s2 = ((toASCII)((Object)bt)).toASCIIFlatName(s);
            }
        } else {
            int dims = this.numDimensions();
            boolean i = false;
            Enumeration e = this.getDimensions();
            while (e.hasMoreElements()) {
                DArrayDimension d = (DArrayDimension)e.nextElement();
                s = s + "[" + d.getSize() + "]";
            }
            s2 = s;
        }
        return s2;
    }

    @Override
    public String toASCIIAddRootName(PrintWriter pw, boolean addName, String rootName) {
        if (addName) {
            rootName = this.toASCIIFlatName(rootName);
            pw.print(rootName);
        }
        return rootName;
    }

    private int asciiArray(PrintWriter os, boolean addName, String label, int index, int dims, int[] shape, int offset) {
        if (dims == 1) {
            if (addName) {
                os.print(label);
            }
            for (int i = 0; i < shape[offset]; ++i) {
                PrimitiveVector pv = this.getPrimitiveVector();
                if (pv instanceof BaseTypePrimitiveVector) {
                    BaseType bt = ((BaseTypePrimitiveVector)pv).getValue(index++);
                    if (i > 0) {
                        if (bt instanceof DString) {
                            os.print(", ");
                        } else {
                            os.println("");
                        }
                    }
                    ((toASCII)((Object)bt)).toASCII(os, false, null, false);
                    continue;
                }
                if (i > 0) {
                    os.print(", ");
                }
                pv.printSingleVal(os, index++);
            }
            if (addName) {
                os.print("\n");
            }
            return index;
        }
        for (int i = 0; i < shape[offset]; ++i) {
            String s = label + "[" + i + "]";
            if (dims - 1 == 1) {
                s = s + ", ";
            }
            index = this.asciiArray(os, addName, s, index, dims - 1, shape, offset + 1);
        }
        return index;
    }
}

